% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellmer.R
\name{mcp_serve_store}
\alias{mcp_serve_store}
\title{Serve a Ragnar store over MCP}
\usage{
mcp_serve_store(
  store,
  store_description = "the knowledge store",
  ...,
  name = NULL,
  title = NULL,
  extra_tools = NULL
)
}
\arguments{
\item{store}{A \code{RagnarStore} object or a file path to a Ragnar DuckDB store.
If a character path is supplied, it is opened with
\code{\link[=ragnar_store_connect]{ragnar_store_connect()}}.}

\item{store_description}{Optional string used in the tool description
presented to clients.}

\item{...}{arguments passed on to \code{ragnar_retrieve()}.}

\item{name, title}{Optional tool function name and title. By default,
\code{store@name} and \code{store@title} will be used if present. The tool \code{name}
must be a valid R function name and should be unique with the tools
registered with the \link[ellmer:Chat]{ellmer::Chat} object. \code{title} is used for
user-friendly display.}

\item{extra_tools}{Optional additional tools (list of \code{ellmer::tool()}
objects) to serve alongside the retrieval tool.}
}
\value{
This function blocks the current R process by running an MCP server.
It is intended for non-interactive use. Called primarily for side-effects.
}
\description{
Launches an MCP server (via \code{\link[mcptools:server]{mcptools::mcp_server()}}) that exposes a
retrieval tool backed by a Ragnar store. This lets MCP-enabled clients (e.g.,
Codex CLI, Claude Code) call into your store to retrieve relevant
excerpts.
}
\details{
To use this function with
\href{https://developers.openai.com/codex/cli/}{Codex CLI},
add something like this to \verb{~/.codex/config.toml}

\if{html}{\out{<div class="sourceCode toml">}}\preformatted{[mcp_servers.quartohelp]
command = "Rscript"
args = [
  "-e",
  "ragnar::mcp_serve_store('/path/to/ragnar.store', top_k=10)"
]
}\if{html}{\out{</div>}}

You can confirm the agent can search the ragnar store by inspecting the
output from the \verb{/mcp} command, or by asking it "What tools do you have
available?".
}
