% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_model.R
\name{multivariate_model}
\alias{multivariate_model}
\title{Model the Data with Multivariate Adjustment}
\usage{
multivariate_model(
  formula,
  data,
  columns,
  a_c_matrix,
  n_burn = 1000,
  n_thin = 1,
  n_steps = 10000,
  seed = 42,
  b0 = 0,
  capital_b_0 = 1e-06,
  sampler = "Metropolis",
  c0 = 0.001,
  d0 = 0.001,
  univariate = FALSE,
  sds = NULL,
  variances = NULL
)
}
\arguments{
\item{formula}{character The model formula}

\item{data}{data.frame The data to model}

\item{columns}{vector The columns that are relevant}

\item{a_c_matrix}{matrix The attenuation-contamination matrix}

\item{n_burn}{numeric Number of draws to burn at the start, default = 1000}

\item{n_thin}{numeric Thinning factor for the draws, default = 1}

\item{n_steps}{numeric The total number of draws to run, default = 10,000}

\item{seed}{numeric The random seed to set}

\item{b0}{numeric The prior mean of the beta}

\item{capital_b_0}{numeric The precision of the beta}

\item{sampler}{character The sampler to use for the model}

\item{c0}{numeric Shape parameter for gamma}

\item{d0}{numeric Scale parameter for gamm}

\item{univariate}{bool Whether or not to run the univariate model,
default = TRUE}

\item{sds}{list If you are running the univariate model, the listing of
standard deviations needs to be applied}

\item{variances}{list If you are running the univariate model, the listing of
variances need to be applied}
}
\value{
List with fitted models ready for further analysis
}
\description{
Using the methodology generated by Muoko et. al (see README for
full citation), run the modelling with the JAGS sampler. This model
uses the calculated attenuation-contamination matrix to adjust
the various covariates needed in the model. The function accepts
the computed pre-model, the attenuation-contamination coefficient,,
a model string, and standard deviations. There is an optional
argument for also fitting the univariate model to run further
comparisons between the naive, univariate, and multivariate models
in later steps.
}
\examples{
columns <- c("fruit", "veg", "tobacco")
fruit_v_coef <- generate_coefficient(100, 0.3, 0.8, 0.95)
veg_v_coef <- generate_coefficient(100, 0.25, 0.75, 0.95)
tob_v_coef <- generate_coefficient(100, 0.4, 0.7, 0.95)
validity_coefficients <- c(fruit_v_coef, veg_v_coef, tob_v_coef)
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
output <- acme_model(data, columns)
lambda <- attenuation_matrix(
  output,
  columns,
  validity_coefficients,
)
model_output <- multivariate_model(
  "BMI ~ fruit + veg + tobacco",
  data = data,
  columns = columns,
  a_c_matrix = lambda$matrix,
  sds = lambda$sds,
  variances = lambda$variances,
  univariate = TRUE
)
}
