% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_primitives.R
\name{severity_to_weight}
\alias{severity_to_weight}
\title{Map Severity to Numeric Weight}
\usage{
severity_to_weight(severity)
}
\arguments{
\item{severity}{Character vector of canonical severity values
(\code{info}, \code{low}, \code{medium}, \code{high}, \code{critical}).}
}
\value{
Numeric vector of weights.
}
\description{
Converts canonical severity labels to numeric penalty multipliers on
a 0--1 scale.
}
\details{
Default mapping:
\itemize{
\item \code{info}     = 0.00
\item \code{low}      = 0.25
\item \code{medium}   = 0.50
\item \code{high}     = 0.75
\item \code{critical} = 1.00
}
}
\examples{
severity_to_weight(c("low", "high", "critical"))

}
