% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_primitives.R
\name{aggregate_indicator_score}
\alias{aggregate_indicator_score}
\title{Aggregate Indicator Scores}
\usage{
aggregate_indicator_score(
  ev,
  by = "indicator_id",
  method = c("mean", "min", "weighted")
)
}
\arguments{
\item{ev}{A valid evidence data.frame.}

\item{by}{Character vector of column names to group by.
Default: \code{c("indicator_id")}.}

\item{method}{Aggregation method: \code{"mean"}, \code{"min"}, or \code{"weighted"}.
The \code{"weighted"} method uses \code{\link[=severity_to_weight]{severity_to_weight()}} and
\code{\link[=result_to_score]{result_to_score()}}.}
}
\value{
A data.frame with grouping columns plus \code{score} (0--1) and
\code{n_evidence} (count of rows).
}
\description{
Computes summary scores from an evidence table, grouped by one or more
columns.
}
\examples{
ctx <- suppressMessages(r4sub_run_context("STUDY1", "DEV"))
ev <- suppressMessages(as_evidence(
  data.frame(
    asset_type = rep("validation", 3), asset_id = rep("ADSL", 3),
    source_name = rep("pinnacle21", 3),
    indicator_id = c("SD0001", "SD0001", "SD0002"),
    indicator_name = c("SD0001", "SD0001", "SD0002"),
    indicator_domain = rep("quality", 3),
    severity = c("high", "medium", "low"),
    result = c("fail", "warn", "pass"),
    stringsAsFactors = FALSE
  ),
  ctx = ctx
))
aggregate_indicator_score(ev, by = "indicator_id", method = "weighted")

}
