"use strict";

// Generated by CoffeeScript 2.5.1
// iplotMScanone_noeff: image of lod curves linked to plot of lod curves
// Karl W Broman
var iplotMScanone_noeff;

iplotMScanone_noeff = function iplotMScanone_noeff(widgetdiv, lod_data, times, chartOpts) {
  var altrectcolor, axispos, c, chartdivid, chrGap, chrlinecolor, chrlinewidth, colors, g_heatmap, g_horpanel, g_verpanel, hbot, height, horpanel, horslice, htop, i, j, k, len, len1, linecolor, linewidth, margin, mylodheatmap, nullcolor, nxticks, plotHorSlice, plotVerSlice, pointcolor, pointcolorhilit, pointsize, pointstroke, rectcolor, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref22, ref23, ref24, ref25, ref26, ref27, ref28, ref29, ref3, ref30, ref4, ref5, ref6, ref7, ref8, ref9, svg, these_pos, title, titlepos, verpanel, verpanel_axis_text, verpanel_xscale, verslice, widgetdivid, width, wleft, wright, x, xlab, xlim, xticks, ylab, zlab, zlim, zmax, zthresh;
  // chartOpts start
  height = (ref = chartOpts != null ? chartOpts.height : void 0) != null ? ref : 700; // height of chart in pixels
  width = (ref1 = chartOpts != null ? chartOpts.width : void 0) != null ? ref1 : 1000; // width of chart in pixels
  title = (ref2 = chartOpts != null ? chartOpts.title : void 0) != null ? ref2 : ""; // title for chart
  wleft = (ref3 = chartOpts != null ? chartOpts.wleft : void 0) != null ? ref3 : width * 0.65; // width of left panels in pixels
  htop = (ref4 = chartOpts != null ? chartOpts.htop : void 0) != null ? ref4 : height / 2; // height of top panels in pixels
  margin = (ref5 = chartOpts != null ? chartOpts.margin : void 0) != null ? ref5 : {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 0 // margins in pixels (left, top, right, bottom, inner)
  };
  axispos = (ref6 = chartOpts != null ? chartOpts.axispos : void 0) != null ? ref6 : {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5 // position of axis labels in pixels (xtitle, ytitle, xlabel, ylabel)
  };
  titlepos = (ref7 = chartOpts != null ? chartOpts.titlepos : void 0) != null ? ref7 : 20; // position of chart title in pixels
  chrGap = (ref8 = chartOpts != null ? chartOpts.chrGap : void 0) != null ? ref8 : 6; // gap between chromosomes in pixels
  rectcolor = (ref9 = chartOpts != null ? chartOpts.rectcolor : void 0) != null ? ref9 : "#E6E6E6"; // color of lighter background rectangle
  altrectcolor = (ref10 = chartOpts != null ? chartOpts.altrectcolor : void 0) != null ? ref10 : "#C8C8C8"; // color of darker background rectangle
  nullcolor = (ref11 = chartOpts != null ? chartOpts.nullcolor : void 0) != null ? ref11 : "#E6E6E6"; // color for pixels with null values
  chrlinecolor = (ref12 = chartOpts != null ? chartOpts.chrlinecolor : void 0) != null ? ref12 : ""; // color of lines between chromosomes (if "", leave off)
  chrlinewidth = (ref13 = chartOpts != null ? chartOpts.chrlinewidth : void 0) != null ? ref13 : 2; // width of lines between chromosomes
  colors = (ref14 = chartOpts != null ? chartOpts.colors : void 0) != null ? ref14 : ["slateblue", "white", "crimson" // heat map colors
  ];
  zlim = (ref15 = chartOpts != null ? chartOpts.zlim : void 0) != null ? ref15 : null; // z-axis limits
  zthresh = (ref16 = chartOpts != null ? chartOpts.zthresh : void 0) != null ? ref16 : null; // lower z-axis threshold for display in heat map
  xlab = (ref17 = chartOpts != null ? chartOpts.xlab : void 0) != null ? ref17 : null; // x-axis label for LOD heatmap)
  ylab = (ref18 = chartOpts != null ? chartOpts.ylab : void 0) != null ? ref18 : ""; // y-axis label for LOD heatmap (also used as x-axis label on effect plot)
  zlab = (ref19 = chartOpts != null ? chartOpts.zlab : void 0) != null ? ref19 : "LOD score"; // z-axis label for LOD heatmap (really just used as y-axis label in the two slices)
  linecolor = (ref20 = chartOpts != null ? chartOpts.linecolor : void 0) != null ? ref20 : "darkslateblue"; // color of LOD curves
  linewidth = (ref21 = chartOpts != null ? chartOpts.linewidth : void 0) != null ? ref21 : 2; // width of LOD curves
  pointsize = (ref22 = chartOpts != null ? chartOpts.pointsize : void 0) != null ? ref22 : 0; // size of points in vertical slice (default = 0 corresponds plotting curves rather than points)
  pointcolor = (ref23 = chartOpts != null ? chartOpts.pointcolor : void 0) != null ? ref23 : "slateblue"; // color of points in vertical slice
  pointcolorhilit = (ref24 = chartOpts != null ? chartOpts.pointcolorhilit : void 0) != null ? ref24 : "crimson"; // color of highlighted point in vertical slice
  pointstroke = (ref25 = chartOpts != null ? chartOpts.pointstroke : void 0) != null ? ref25 : "black"; // color of outer circle for points in vertical slice
  nxticks = (ref26 = chartOpts != null ? chartOpts.nxticks : void 0) != null ? ref26 : 5; // no. ticks in x-axis on right-hand panel, if quantitative scale
  xticks = (ref27 = chartOpts != null ? chartOpts.xticks : void 0) != null ? ref27 : null; // tick positions in x-axis on right-hand panel, if quantitative scale
  // chartOpts end
  chartdivid = (ref28 = chartOpts != null ? chartOpts.chartdivid : void 0) != null ? ref28 : 'chart';
  widgetdivid = d3.select(widgetdiv).attr('id');
  // make sure list args have all necessary bits
  margin = d3panels.check_listarg_v_default(margin, {
    left: 60,
    top: 40,
    right: 40,
    bottom: 40,
    inner: 5
  });
  axispos = d3panels.check_listarg_v_default(axispos, {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5
  });
  wright = width - wleft;
  hbot = height - htop;
  // fill in zlim
  zmax = d3panels.matrixMaxAbs(lod_data.lod);
  zlim = zlim != null ? zlim : [-zmax, 0, zmax];
  // a bit more data set up
  if (times != null) {
    lod_data.y = times;
  } else {
    lod_data.ycat = lod_data.lodname;
  }
  // hash for [chr][pos] -> posindex
  lod_data.posIndexByChr = d3panels.reorgByChr(lod_data.chrname, lod_data.chr, function () {
    var results;
    results = [];
    for (i in lod_data.pos) {
      results.push(i);
    }
    return results;
  }());
  if (typeof lod_labels !== "undefined" && lod_labels !== null) {
    // use the lod labels for the lod names
    lod_data.lodname = lod_labels;
  }
  if (lod_data.chrname == null) {
    // create chrname, chrstart, chrend if missing
    lod_data.chrname = d3panels.unique(lod_data.chr);
  }
  if (lod_data.chrstart == null) {
    lod_data.chrstart = [];
    ref29 = lod_data.chrname;
    for (j = 0, len = ref29.length; j < len; j++) {
      c = ref29[j];
      these_pos = function () {
        var results;
        results = [];
        for (i in lod_data.chr) {
          if (lod_data.chr[i] === c) {
            results.push(lod_data.pos[i]);
          }
        }
        return results;
      }();
      lod_data.chrstart.push(d3.min(these_pos));
    }
  }
  if (lod_data.chrend == null) {
    lod_data.chrend = [];
    ref30 = lod_data.chrname;
    for (k = 0, len1 = ref30.length; k < len1; k++) {
      c = ref30[k];
      these_pos = function () {
        var results;
        results = [];
        for (i in lod_data.chr) {
          if (lod_data.chr[i] === c) {
            results.push(lod_data.pos[i]);
          }
        }
        return results;
      }();
      lod_data.chrend.push(d3.max(these_pos));
    }
  }
  // phenotype x-axis
  x = times != null ? times : function () {
    var results;
    results = [];
    for (i in lod_data.lod[0]) {
      results.push(i);
    }
    return results;
  }();
  xlim = times != null ? d3.extent(times) : [-0.5, x.length - 0.5];
  nxticks = times != null ? nxticks : 0;
  xticks = times != null ? xticks : null;
  // set up heatmap
  mylodheatmap = d3panels.lodheatmap({
    height: htop,
    width: wleft,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    chrGap: chrGap,
    rectcolor: rectcolor,
    altrectcolor: altrectcolor,
    chrlinecolor: chrlinecolor,
    chrlinewidth: chrlinewidth,
    colors: colors,
    title: title,
    zlim: zlim,
    zthresh: zthresh,
    ylab: ylab,
    yticks: xticks,
    nyticks: nxticks,
    nullcolor: nullcolor,
    tipclass: widgetdivid
  });
  // add the heatmap
  svg = d3.select(widgetdiv).select("svg");
  g_heatmap = svg.append("g").attr("id", "heatmap");
  mylodheatmap(g_heatmap, lod_data);
  // lod vs position (horizontal) panel
  horpanel = d3panels.chrpanelframe({
    height: hbot,
    width: wleft,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    chrGap: chrGap,
    rectcolor: rectcolor,
    altrectcolor: altrectcolor,
    chrlinecolor: chrlinecolor,
    chrlinewidth: chrlinewidth,
    xlab: xlab,
    ylab: zlab,
    ylim: [0, zlim[2] * 1.05],
    tipclass: widgetdivid
  });
  // create empty panel
  g_horpanel = svg.append("g").attr("transform", "translate(0," + htop + ")").attr("id", "lodchart");
  horpanel(g_horpanel, {
    chr: lod_data.chrname,
    start: lod_data.chrstart,
    end: lod_data.chrend
  });
  // plot lod curves for selected lod column
  horslice = null;
  plotHorSlice = function plotHorSlice(lodcolumn) {
    horslice = d3panels.add_lodcurve({
      linecolor: linecolor,
      linewidth: linewidth,
      pointsize: 0,
      pointcolor: "",
      pointstroke: ""
    });
    return horslice(horpanel, {
      chr: lod_data.chr,
      pos: lod_data.pos,
      marker: lod_data.marker,
      lod: function () {
        var results;
        results = [];
        for (i in lod_data.pos) {
          results.push(d3panels.abs(lod_data.lod[i][lodcolumn]));
        }
        return results;
      }(),
      chrname: lod_data.chrname
    });
  };
  // lod versus phenotype (vertical) panel
  verpanel = d3panels.panelframe({
    height: htop,
    width: wright,
    margin: margin,
    axispos: axispos,
    titlepos: titlepos,
    xlab: ylab,
    ylab: zlab,
    rectcolor: rectcolor,
    xlim: xlim,
    ylim: [0, zlim[2] * 1.05],
    nxticks: nxticks,
    xticks: xticks,
    tipclass: widgetdivid
  });
  g_verpanel = svg.append("g").attr("transform", "translate(" + wleft + ",0)").attr("id", "curvechart");
  verpanel(g_verpanel);
  // add x-axis test if qualitative x-axis scale
  if (times == null) {
    verpanel_axis_text = g_verpanel.append("g").attr("class", "x axis").append("text").text("").attr("y", htop - margin.bottom + axispos.xlabel);
    verpanel_xscale = verpanel.xscale();
  }
  // plot lod versus phenotype curve
  verslice = null;
  plotVerSlice = function plotVerSlice(posindex) {
    if (pointsize > 0) {
      // plot points rather than curves
      verslice = d3panels.add_points({
        pointsize: pointsize,
        pointcolor: pointcolor,
        pointstroke: pointstroke
      });
      return verslice(verpanel, {
        x: x,
        y: function () {
          var results;
          results = [];
          for (i in lod_data.lod[posindex]) {
            results.push(lod_data.lod[posindex][i]);
          }
          return results;
        }()
      });
    } else {
      verslice = d3panels.add_curves({
        linecolor: linecolor,
        linewidth: linewidth
      });
      return verslice(verpanel, {
        x: [x],
        y: [function () {
          var results;
          results = [];
          for (i in lod_data.lod[posindex]) {
            results.push(lod_data.lod[posindex][i]);
          }
          return results;
        }()]
      });
    }
  };
  mylodheatmap.cells().on("mouseover", function (event, d) {
    var p;
    plotHorSlice(d.lodindex);
    g_horpanel.select("g.title text").text("" + lod_data.lodname[d.lodindex]);
    plotVerSlice(lod_data.posIndexByChr[d.chr][d.posindex]);
    p = d3.format(".1f")(d.pos);
    g_verpanel.select("g.title text").text(d.chr + "@" + p);
    if (times == null) {
      verpanel_axis_text.text("" + lod_data.lodname[d.lodindex]).attr("x", verpanel_xscale(d.lodindex));
    }
    if (pointsize > 0) {
      return verslice.points().attr("fill", function (z, i) {
        if (i === d.lodindex) {
          return pointcolorhilit;
        }
        return pointcolor;
      });
    }
  }).on("mouseout", function () {
    if (horslice != null) {
      horslice.remove();
    }
    if (verslice != null) {
      verslice.remove();
    }
    g_horpanel.select("g.title text").text("");
    g_verpanel.select("g.title text").text("");
    if (times == null) {
      verpanel_axis_text.text("");
    }
    if (pointsize > 0) {
      return verslice.points().attr("fill", pointcolor);
    }
  });
  if (chartOpts.heading != null) {
    d3.select("div#htmlwidget_container").insert("h2", ":first-child").html(chartOpts.heading).style("font-family", "sans-serif");
  }
  if (chartOpts.caption != null) {
    d3.select("body").append("p").attr("class", "caption").html(chartOpts.caption);
  }
  if (chartOpts.footer != null) {
    return d3.select("body").append("div").html(chartOpts.footer).style("font-family", "sans-serif");
  }
};