% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneExpr-data.R
\docType{data}
\name{geneExpr}
\alias{geneExpr}
\title{Anonymized gene expression data}
\format{
A list containing a matrix `expr` with the gene
expression data plus a vector `genotype` with the genotypes.
}
\usage{
data(geneExpr)
}
\description{
An anonymized set of gene expression values, for 100
genes all influenced by a common locus, plus a vector of genotypes
for the 491 individuals.
}
\examples{
data(geneExpr)
\donttest{
# heat map of correlation matrix, linked to scatterplots
iplotCorr(geneExpr$expr, geneExpr$genotype, reorder=TRUE)}
}
\author{
Karl W Broman, 2013-05-16
}
\keyword{datasets}
