
test_that("Create plot label PDF successful generation", {
  #skip_on_cran()
  path <- tempdir()
  setwd(path)
  expect_invisible(
    create_label(wdt = 2, 
             hgt = 1, 
             page_wdt = 8.5, 
             page_hgt = 11, 
             top_mar = 0.625, 
             bot_mar = 0.625, 
             left_mar = 0.625, 
             right_mar = 0.625, 
             numrow = 8L, 
             numcol = 3L, 
             filename = 'PlotLabel', 
             font_sz = 8,
             Treetag = FALSE,
             family = 'sans', 
             rounded = TRUE, 
             print_across = TRUE,
             rect = TRUE,
             top_left_1 = paste("Plot:", 101:110), 
             top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
             top_right_1 = paste("Rep:", rep(1, 10)), 
             top_right_2 = paste("Col:", c(1:6, 1:4)), 
             center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
             center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
             center_right_3 = rep("AWk", 10), 
             bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
             bottom_left_2 = paste0("G-", 1:10),
             unique_id = paste("KUMASI2023_PYT", c(101:110), 
                               c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                sep = "_"), 
             ec_level = 3))
  expect_true(length(list.files(path = ".", pattern = "\\.pdf$")) > 0)
  on.exit(unlink(path))
  # expect_true(length(list.files(path = ".", pattern = "\\.csv$")) > 0)
  
})


test_that("Create Treetag plot label PDF successful generation", {
  #skip_on_cran()
  path <- tempdir()
  setwd(path)
  expect_invisible(
    create_label(wdt = 1, 
                 hgt = 6, 
                 page_wdt = 4, 
                 page_hgt = 6, 
                 top_mar = 0, 
                 bot_mar = 0, 
                 left_mar = 0, 
                 right_mar = 0, 
                 numrow = 1L, 
                 numcol = 4L, 
                 filename = 'PlotLabel', 
                 font_sz = 10,
                 Treetag = TRUE,
                 family = 'sans', 
                 rounded = FALSE, 
                 top_left_1 = paste("Plot:", 101:110), 
                 top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                 top_right_1 = paste("Rep:", rep(1, 10)), 
                 top_right_2 = paste("Col:", c(1:6, 1:4)), 
                 center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                 center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                 center_right_3 = rep("AWk", 10), 
                 bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                 bottom_left_2 = paste0("G-", 1:10),
                 unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                   c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                   sep = "_"),
                 ec_level = 3))
  expect_true(length(list.files(path = ".", pattern = "\\.pdf$")) > 0)
  on.exit(unlink(path))
  # expect_true(length(list.files(path = ".", pattern = "\\.csv$")) > 0)
  
})


test_that("Create plot label input errors", {
  #skip_on_cran()
  expect_error(create_label(wdt = 2, 
                      hgt = 1, 
                      page_wdt = 8.5, 
                      page_hgt = 11, 
                      top_mar = 2, 
                      bot_mar = 2, 
                      left_mar = 0.625, 
                      right_mar = 0.625,  
                      numrow = 8L, 
                      numcol = 3L, 
                      filename = 'PlotLabel', 
                      font_sz = 8,
                      Treetag = FALSE,
                      family = 'sans', 
                      rounded = TRUE, 
                      top_left_1 = paste("Plot:", 101:110), 
                      top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                      top_right_1 = paste("Rep:", rep(1, 10)), 
                      top_right_2 = paste("Col:", c(1:6, 1:4)), 
                      center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                      center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                      center_right_3 = rep("AWk", 10), 
                      bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                      bottom_left_2 = paste0("G-", 1:10),
                      unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                        c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                        sep = "_") ), 
             "Page setup does not match label setup per page.")
  
  expect_error(create_label(wdt = 'A', 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,   
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'wdt' must be a positive numeric value.")
  
  
  expect_error(create_label(wdt = 2, 
                            hgt = 'b', 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,  
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'hgt' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 'c', 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'page_wdt' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 'aa', 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,  
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'page_hgt' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 'bb',  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'top_mar' must be a positive numeric value.")
  
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 'bb',  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'bot_mar' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 'bb', 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'left_mar' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 'bb',    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'right_mar' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 'aa', 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'numrow' must be a positive integer.")
  
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 'aa', 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'numcol' must be a positive integer.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 'aa',
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'font_sz' must be a positive numeric value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = 2,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'Treetag' must be a logical or boolean value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = 2, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'rounded' must be a logical or boolean value.")
  
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 1, 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'filename' must be string value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 1, 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = paste("KUMASI2023_PYT", c(101:110), 
                                              c(rep(1, 6), rep(2, 4)), c(1:6, 1:4),
                                              sep = "_") ), 
               "'family' must be string value.")
  
  expect_error(create_label(wdt = 2, 
                            hgt = 1, 
                            page_wdt = 8.5, 
                            page_hgt = 11, 
                            top_mar = 0.625,  
                            bot_mar = 0.625,  
                            left_mar = 0.625, 
                            right_mar = 0.625,    
                            numrow = 8L, 
                            numcol = 3L, 
                            filename = 'PlotLabel', 
                            font_sz = 8,
                            Treetag = FALSE,
                            family = 'sans', 
                            rounded = TRUE, 
                            top_left_1 = paste("Plot:", 101:110), 
                            top_left_2 = paste("Row:", c(rep(1, 6), rep(2, 4))), 
                            top_right_1 = paste("Rep:", rep(1, 10)), 
                            top_right_2 = paste("Col:", c(1:6, 1:4)), 
                            center_right_1 = paste("iBLOCK:", c(rep(1, 6), rep(2, 4))), 
                            center_right_2 = paste("Seed:", rep("OFF_NUR", 10)), 
                            center_right_3 = rep("AWk", 10), 
                            bottom_left_1 = paste("Loc:", rep("BAMBEY", 10)), 
                            bottom_left_2 = paste0("G-", 1:10),
                            unique_id = NULL ), 
               "`unique_id` is required when `include_qr = TRUE`.")
  
  
  
})
