% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_project.R
\name{new_project}
\alias{new_project}
\title{Project Template}
\usage{
new_project(project = "new", path = getwd(), open = is.global(2), ...)
}
\arguments{
\item{project}{A character vector of the project name.}

\item{path}{The path to where the project should be created.  Default is the 
current working directory.}

\item{open}{logical.  If \code{TRUE} the project will be opened in RStudio.
The default is to test if \code{new_project} is being used in the global 
environment, if it is then the project directory will be opened.}

\item{\ldots}{ignored.}
}
\value{
Creates a project template.
}
\description{
Generate a project template to increase efficiency.
}
\details{
The project template includes these main directories and scripts:
\describe{
\item{CODEBOOK}{ - A directory to store coding conventions or demographics data:
\describe{
    \item{KEY.csv}{ - A blank template for demographic information}
    }  
}
\item{CORRESPONDENCE}{ - A directory to store correspondence and agreements with the client:
\describe{
    \item{CONTACT_INFO.txt}{ - A text file to put research team members' contact information}     
    } 
}
\item{DATA}{ - A directory to store data:}
\describe{
    \item{CLEANED_TRANSCRIPTS}{ - A directory to store the cleaned transcripts (If the transcripts are already cleaned you may choose to not utilize the RAW_TRANSCRIPTS directory)}     
    \item{CM_DATA}{ - A directory to export/import scripts for cm_xxx family of functions} 
    \item{DATA_FOR_REVIEW}{ - A directory to put data that may need to be altered or needs to be inspected more closely} 
    \item{RAW_DATA}{ - A directory to store non-transcript data related to the project:
        \describe{
          \item{ANALYTIC_MEMOS}{ - A directory to put audio files (or shortcuts)}     
          \item{AUDIO}{ - A directory to put audio files (or shortcuts)}     
          \item{FIELD_NOTES}{ - A directory to put audio files (or shortcuts)}   
          \item{PAPER_ARTIFACTS}{ - A directory to put paper artifacts}  
          \item{PHOTOGRAPHS}{ - A directory to put photographs}  
          \item{VIDEO}{ - A directory to put video files (or shortcuts)}  
        } 
    } 
    \item{TRANSCRIPTS}{ - A directory to put transcription data:
        \describe{
            \item{CLEANED_TRANSCRIPTS}{ - A directory to store the cleaned transcripts (If the transcripts are already cleaned you may choose to not utilize the RAW_TRANSCRIPTS directory)}     
            \item{RAW_TRANSCRIPTS}{ - A directory to store the raw transcripts}
        } 
    } 
}
\item{DOCUMENTATION}{ - A directory to store documents related to the project}
\item{PLOTS}{ - A directory to store plots}
\item{REPORTS}{ - A directory with report and presentation related tools.}
\item{SCRIPTS}{ - A directory to store scripts; already contains the following:
\describe{
    \item{01_clean_data.R}{ - initial cleaning of raw transcripts}
    \item{02_analysis_I.R}{ - initial analysis}
    \item{03_plots.R}{ - plotting script}
    }
}
\item{TABLES}{ - A directory to export tables to}  
\item{WORD_LISTS}{ - A directory to store word lists that can be sourced and supplied to functions}
\item{extra_functions.R}{ - A script to store user made functions related to the project
\describe{
    \item{email}{ - A function to view, and optionally copy to the clipboard, emails for the client/lead researcher, analyst and/or other project members (information taking from ~/CORRESPONDENCE/CONTACT_INFO.txt file)}
    \item{todo}{ - A function to view, and optionally copy to the clipboard, non-completed tasks from the \code{TO_DO.txt} file}
    }
}
\item{LOG}{ - A text file documenting project changes/needs etc.}
\item{PROJECT_WORKFLOW_GUIDE.pdf}{ - A pdf explaining the structure of the project template}
\item{xxx.Rproj}{ - A project file used by RRtudio; clicking this will open the project in RStudio.} 
\item{TO_DO}{ - A text file documenting project tasks}
}

The template comes with a .Rproj file.  This makes operating in 
RStudio very easy.  The file can be kept on 
the desktop or a git application such as github,
bitbucket or dropbox, 
depending on what the client/research team is comfortable utilizing.
}
