% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesR2.R
\name{test_corrected_bayes_R2}
\alias{test_corrected_bayes_R2}
\title{Test the corrected implementation with a mixed-effects example}
\usage{
test_corrected_bayes_R2()
}
\description{
Test the corrected implementation with a mixed-effects example
}
\examples{
\dontrun{
# Test with mixed-effects model
library(qbrms)

# Create sample data with strong group effects
set.seed(123)
n_groups <- 10
n_per_group <- 20
n_total <- n_groups * n_per_group

data <- data.frame(
  group = factor(rep(1:n_groups, each = n_per_group)),
  x = rnorm(n_total),
  group_effect = rep(rnorm(n_groups, 0, 2), each = n_per_group)
)

# Generate response with strong group effects
data$y <- 2 + 0.5 * data$x + data$group_effect + rnorm(n_total, 0, 0.5)

# Fit mixed-effects model
fit_mixed <- qbrms(y ~ x + (1|group), data = data, family = gaussian())

# Compute Bayesian R-squared (should now match brms closely)
r2_corrected <- bayes_R2(fit_mixed, verbose = TRUE)
print(r2_corrected)

# Should show high R-squared due to strong group effects
}
}
