% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_tables.R
\name{tab_model}
\alias{tab_model}
\title{Create HTML Table for qbrms Models with Enhanced Styling}
\usage{
tab_model(
  ...,
  show.ci = TRUE,
  ci.lvl = 0.95,
  show.rope = FALSE,
  rope = c(-0.1, 0.1),
  show.p_sig = FALSE,
  show.pd = FALSE,
  show.bf = FALSE,
  digits = 2,
  title = "Model Results",
  file = NULL,
  CSS = NULL,
  dv.labels = NULL,
  pred.labels = NULL,
  show.intercept = TRUE,
  show.r2 = FALSE,
  show.icc = FALSE,
  show.nobs = TRUE,
  bootstrap = TRUE,
  table.style = "default",
  font.family = "system-ui, -apple-system, sans-serif",
  font.size = "14px",
  header.bg = "#f8f9fa",
  stripe.bg = "#f9f9f9",
  verbose = FALSE
)
}
\arguments{
\item{...}{One or more qbrms_fit objects to display in the table}

\item{show.ci}{Logical; show credible intervals (default TRUE)}

\item{ci.lvl}{Credible interval level (default 0.95)}

\item{show.rope}{Logical; show ROPE analysis (default FALSE)}

\item{rope}{Numeric vector c(lower, upper) for ROPE bounds}

\item{show.p_sig}{Logical; show probability of practical significance (default FALSE)}

\item{show.pd}{Logical; show probability of direction (default FALSE)}

\item{show.bf}{Logical; show Bayes factors (default FALSE)}

\item{digits}{Number of decimal places (default 2)}

\item{title}{Character; table title}

\item{file}{Character; file path to save HTML output (optional)}

\item{CSS}{Character; custom CSS styling (optional)}

\item{dv.labels}{Character vector of dependent variable labels}

\item{pred.labels}{Named character vector for predictor labels}

\item{show.intercept}{Logical; show intercept row (default TRUE)}

\item{show.r2}{Logical; show R-squared if available (default FALSE)}

\item{show.icc}{Logical; show ICC for mixed models (default FALSE)}

\item{show.nobs}{Logical; show number of observations (default TRUE)}

\item{bootstrap}{Logical; use Bootstrap CSS framework (default TRUE)}

\item{table.style}{Character; table style theme. Options: "default", "minimal", "academic", "modern"}

\item{font.family}{Character; CSS font family (default "system-ui")}

\item{font.size}{Character; base font size (default "14px")}

\item{header.bg}{Character; header background colour (default "#f8f9fa")}

\item{stripe.bg}{Character; striped row background colour (default "#f9f9f9")}

\item{verbose}{Logical; print progress (default FALSE)}
}
\value{
An object of class "qbrms_html_table" containing the HTML code
}
\description{
Generate APA-style HTML tables for qbrms model outputs with customizable styling options.
}
