% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold_cv.R
\name{kfold_cv}
\alias{kfold_cv}
\title{K-fold cross-validation for qbrms models (ordinal and standard families)}
\usage{
kfold_cv(
  object,
  data = NULL,
  family = gaussian(),
  K = 10,
  folds = NULL,
  seed = NULL,
  stratify = TRUE,
  parallel = FALSE,
  workers = NULL,
  keep_fits = FALSE,
  engine = c("auto", "tmb", "polr"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{Either a fitted qbrms/qbrmO object \strong{or} a formula.}

\item{data}{Required only if \code{object} is a formula. Ignored if \code{object} is a fit.}

\item{family}{Optional family override (used if \code{object} is a formula; fits use their own).}

\item{K}{Number of folds (default 10).}

\item{folds}{Optional integer vector of length \code{nrow(data)} giving fold IDs.}

\item{seed}{Optional seed for stratified folds.}

\item{stratify}{Logical; stratify on response if factor/ordered (default TRUE).}

\item{parallel}{Logical; use \code{future.apply} if available (default FALSE).}

\item{workers}{Optional workers when parallel and no plan is set.}

\item{keep_fits}{Logical; keep per-fold fits (default FALSE).}

\item{engine}{Ordinal CV engine: \code{"auto"} (default), \code{"tmb"}, or \code{"polr"}.
Only used for \strong{ordinal} families during CV refits. \code{"auto"} uses
\code{getOption("qbrms.kfold.ordinal_engine", "polr")}.}

\item{verbose}{Logical; brief progress (default TRUE).}

\item{...}{Passed to \code{qbrms()} when refitting folds (non-ordinal or \code{engine="tmb"}).}
}
\value{
An object of class \code{qbrms_kfold} with ELPD, pointwise elpd, SE, etc.
}
\description{
Performs K-fold cross-validation either from a fitted model or from
\code{formula + data}. For \strong{ordinal (cumulative/ordinal)} families, you can
choose the re-fit engine used inside CV: TMB (\code{qbrmO}) or a robust
fallback using \code{MASS::polr} that avoids TMB compilation in each fold.
Your original fitted model is unchanged.
}
