% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributional_syntax.R
\name{bf}
\alias{bf}
\title{Create a Bayesian Formula}
\usage{
bf(formula, ..., flist = NULL, family = NULL, nl = FALSE)
}
\arguments{
\item{formula}{Main model formula (for the mean/location parameter).}

\item{...}{Additional formulas for distributional parameters (e.g., \code{sigma ~ x}).}

\item{flist}{Optional list of formulas (for internal use).}

\item{family}{Same as in \code{qbrms()} (optional here).}

\item{nl}{Logical; indicating if the model is non-linear (not yet fully supported).}
}
\value{
An object of class \code{brmsformula} (and \code{qbrmsformula})
containing the parsed formulas.
}
\description{
Function to set up a model formula for use in \code{qbrms}, allowing
specification of distributional parameters (e.g., sigma) in addition to the
mean structure.
}
\details{
This function mimics the \code{brms::bf()} syntax to allow users familiar
with brms to define distributional models.

Supported distributional parameters depend on the family:
\itemize{
\item \code{gaussian}: \code{sigma} (residual standard deviation)
\item \code{student_t}: \code{sigma}, \code{nu} (degrees of freedom)
\item \code{lognormal}: \code{sigma} (shape parameter)
\item \code{beta}: \code{phi} (precision)
\item \code{simplex}: \code{phi} (precision)
}
}
\examples{
\dontrun{
# Standard model
f1 <- bf(y ~ x)

# Distributional model (heteroscedasticity)
# Sigma varies by group
f2 <- bf(y ~ x, sigma ~ group)
}

}
