% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{summary.pvEBayes}
\alias{summary.pvEBayes}
\title{Summary method for a pvEBayes object}
\usage{
\method{summary}{pvEBayes}(object, return = NULL, ...)
}
\arguments{
\item{object}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{return}{a character string specifying which component the summary
function should return.Valid options include: "prior parameters",
"likelihood", "detected signal" and "posterior draws". If set to NULL
(default), all components will be returned in a list. Note that the input
for 'return' is case-sensitive.}

\item{...}{other input parameters. Currently unused.}
}
\value{
a list including estimated prior parameters, log_marginal_likelihood,
indicator matrix of detected signal and posterior_draws for each AE-drug
pair.
}
\description{
This function defines the S3 \code{summary} method for objects of class
\code{pvEBayes}. It provides a detailed summary of the fitted model.
}
\examples{

obj <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.5, n_posterior_draws = 10000
)

summary(obj)

}
