% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_robust.R
\name{norm_robust}
\alias{norm_robust}
\title{Robust Standardization (Median-MAD)}
\usage{
norm_robust(x, na.rm = TRUE, constant = 1.4826)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should NA values be removed? Default is \code{TRUE}.}

\item{constant}{A scale factor for MAD calculation. Default is 1.4826,
which ensures consistency with the standard deviation for normal distributions.}
}
\value{
A numeric vector.
  If MAD is 0 (e.g., more than 50% of the data are identical), the function
  returns a centered vector (x - median) and issues a warning.
}
\description{
Standardizes a numeric vector using robust statistics: median and
median absolute deviation (MAD). This method is less sensitive to outliers
compared to Z-score standardization.
}
\details{
Formula: \eqn{x' = \frac{x - \text{median}(x)}{\text{mad}(x)}}
}
\examples{
# Data with an outlier
x <- c(1, 2, 3, 4, 100)

# Z-score is heavily affected by the outlier
norm_zscore(x)

# Robust scaler handles it better
norm_robust(x)
}
\references{
Huber, P. J. (1981). \emph{Robust Statistics}. Wiley. ISBN: 978-0-471-41805-4.

Hampel, F. R. (1974). The influence curve and its role in robust estimation.
\emph{Journal of the American Statistical Association}, 69(346), 383-393.
}
