% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altprimary.R
\name{altprimary}
\alias{altprimary}
\title{Power calculation for multiple alternative (at least one) primary continuous endpoints
assuming known covariance matrix}
\usage{
altprimary(
  K,
  n1 = NULL,
  n.ratio = 1,
  delta = NULL,
  Sigma,
  sd,
  rho,
  alpha = 0.025,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{K}{The number of endpoints.}

\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{delta}{A vector of length K of the true mean differences mu1k - mu2k; must all be positive.}

\item{Sigma}{The covariance matrix of the K outcomes, of dimension K x K.}

\item{sd}{A vector of length K of the standard deviations of the K outcomes.}

\item{rho}{A vector of length 0.5\emph{K}(K-1) of the correlations among the K outcomes.}

\item{alpha}{The significance level (type 1 error rate) for each test; defaults to 0.025.
A one-sided test is assumed.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Calculates power and sample size for the case of comparing two groups on the means of K
continuous endpoints and concluding that the trial is a 'success' if the
null hypothesis is rejected for at least one of the K endpoints.
All mean differences must be specified as positive; the scale for some outcomes may need to be reversed
to meet this condition. All tests are assumed to be upper-tailed, one-sided tests. Can
solve for power, n1, n.ratio or alpha.

To use a Bonferroni correction for multiple comparisons, specify alpha as
the desired familywise error rate (FWER) divided by K. For example, for one-sided FWER of 0.025
and K = 2 endpoints, specify alpha as 0.0125.

Either sd and rho or Sigma must be specified.

A known covariance matrix is assumed, which can result in a slight overestimate of power and
underestimate of required sample size.
}
\details{
Sozu T, Sugimoto T, Hamasaki T, Evans SR (2015)
Sample Size Determination in Clinical Trials with Multiple Endpoints.
Springer International Publishing, Switzerland.
}
\examples{
altprimary(K = 2, n1 = 100, delta = c(0.4, 0.5), sd = c(1, 1), rho = 0.3,
alpha = 0.025 / 2, power = NULL)

Sigma <- matrix(c(1, 0.3, 0.3, 0.3, 1, 0.3, 0.3, 0.3, 1), nrow = 3, ncol = 3)
altprimary(K = 3, n1 = 100, delta = c(0.2, 0.2, 0.4), Sigma = Sigma,
   alpha = 0.025 / 3, power = NULL)
}
