% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state_nlmixr.R
\name{der_state_plot_nlmixr}
\alias{der_state_plot_nlmixr}
\title{Generate Derivative versus State Plot (nlmixr2)}
\usage{
der_state_plot_nlmixr(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  fit_obj = NULL,
  length_out = 100,
  time_nn = FALSE,
  act = "ReLU",
  plot_type = c("base", "ggplot"),
  beta = 20
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through \emph{fit$fixef}. For optionality, see \strong{Details}.}

\item{fit_obj}{(nlmixr fit object; semi-optional) The fit-object from nlmixr2(...). For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of states between min_state and max_state for derivative calculations.}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{plot_type}{(string) What plot type should be used; "base" or "ggplot"}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}
}
\value{
Displaying derivative versus state plot; returns ggplot-object if \emph{plot_type="ggplot"}
}
\description{
This functions allows to generate a derivative versus state plot for a neural network from a NODE in nlmixr2
}
\details{
Either \emph{est_parms} or \emph{fit_obj} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
\dontrun{
pop_fit <- nlmixr2(node_model_pop,data=data,est="bobyqa")
der_state_plot <- der_state_plot_nlmixr(nn="c",
                                        min_state=0,max_state=10,
                                        fit_obj=pop_fit,
                                        plot_type="ggplot")
}
}
\author{
Dominic Bräm
}
