% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_compartmental.R
\name{non_compartmental}
\alias{non_compartmental}
\title{Non-Compartmental Analysis (NCA) of Plasma Concentration-Time Data (Linear Form)}
\arguments{
\item{data}{A data.frame containing plasma concentration-time data.}

\item{time_col}{Character string indicating the column name for time.}

\item{conc_col}{Character string indicating the column name for concentration.}

\item{dose}{Numeric value for the administered dose.}

\item{group_col}{Optional character string specifying a grouping variable for multiple groups.}

\item{terminal_points}{Number of last points to use for terminal slope estimation (default = 3).}

\item{plot}{Logical; if TRUE, plots concentration-time profile and terminal phase regression.}

\item{annotate}{Logical; if TRUE, annotates plot with PK parameters (only for <= 2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with kel, t1/2, AUC, CL, Vd, and R^2 for each group.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Performs non-compartmental analysis (NCA) on plasma concentration-time data
assuming linear pharmacokinetics. Computes area under the curve (AUC) using trapezoidal rule, estimates
terminal elimination rate constant (kel) by linear regression on the log-linear terminal phase,
calculates half-life (t1/2), clearance (CL), and volume of distribution (Vd).
}
\examples{
# Example I: Single-subject non-compartmental analysis
df <- data.frame(
  time = c(0.25, 0.5, 1, 2, 4, 6, 8, 12),
  concentration = c(18.6, 16.9, 14.2, 10.8, 6.9, 4.6, 3.1, 1.9)
)
non_compartmental(
  data = df,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,          # mg
  terminal_points = 3, # last 3 points (6, 8, 12 h)
  plot = TRUE,
  annotate = TRUE
)

# Example II: Two-group comparison (reference vs test formulation)
df_groups <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 2),
  concentration = c(
    17.9, 16.2, 13.7, 10.1, 6.3, 4.1, 2.8,  # Reference
    20.4, 18.9, 16.1, 12.4, 8.1, 5.6, 3.9   # Test
  ),
  formulation = rep(c("Reference", "Test"), each = 7)
)
non_compartmental(
  data = df_groups,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,            # same dose in both groups
  group_col = "formulation",
  terminal_points = 3,
  plot = TRUE,
  annotate = TRUE
)

# Example III: Multiple subjects with extended terminal phase
df_subjects <- data.frame(
  time = rep(c(0.5, 1, 2, 4, 8, 12, 24), 3),
  concentration = c(
    15.2, 13.9, 11.4, 7.6, 4.1, 2.6, 1.3,  # Subject 1
    14.8, 13.2, 10.9, 7.2, 3.9, 2.4, 1.2,  # Subject 2
    16.0, 14.6, 12.0, 8.1, 4.5, 2.9, 1.5   # Subject 3
  ),
  subject = rep(paste0("S", 1:3), each = 7)
)
non_compartmental(
  data = df_subjects,
  time_col = "time",
  conc_col = "concentration",
  dose = 150,
  group_col = "subject",
  terminal_points = 4,
  plot = TRUE,
  annotate = FALSE
)
}
\references{
Gibaldi, M. & Perrier, D. (1982) <isbn:9780824710422> Pharmacokinetics,
2nd Edition. Marcel Dekker, New York.

Gabrielsson, J. & Weiner, D. (2000) <isbn:9186274929> Pharmacokinetic/Pharmacodynamic
Data Analysis: Concepts and Applications, 3rd Edition, Revised and Expanded.
Swedish Pharmaceutical Press, Stockholm.
}
\author{
Paul Angelo C. Manlapaz
}
