% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{clusterer}
\alias{clusterer}
\title{Function to cluster non-conformity scores using either Kolmogorov-Smirnov or K-means clustering}
\usage{
clusterer(
  ncs,
  m,
  class_vec,
  maxit = 100,
  method = c("ks", "kmeans"),
  q = seq(0.1, 0.9, by = 0.1),
  min_class_size = 10
)
}
\arguments{
\item{ncs}{Vector of non-conformity scores}

\item{m}{Number of clusters to form}

\item{class_vec}{Vector of class labels}

\item{maxit}{Maximum number of iterations for the clustering algorithm}

\item{method}{Clustering method to use, either 'ks' for Kolmogorov-Smirnov or 'kmeans' for K-means clustering}

\item{q}{Quantiles to use for K-means clustering, default is a sequence from 0.1 to 0.9 in steps of 0.1}

\item{min_class_size}{Minimum number of observations required in a class to be included in clustering}
}
\value{
A vector of cluster assignments, with attributes containing the clusters, coverage gaps, method used, number of clusters, and Calibrated Clustering index
}
\description{
Function to cluster non-conformity scores using either Kolmogorov-Smirnov or K-means clustering
}
