% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{Prochloro_Normalise_F}
\alias{Prochloro_Normalise_F}
\title{Normalize F matrix specifically for Prochlorococcus pigments}
\usage{
Prochloro_Normalise_F(Fmat)
}
\arguments{
\item{Fmat}{Matrix with pigment ratios, where the last column is chlorophyll a
and second-to-last column is divinyl chlorophyll a}
}
\value{
A list containing:
\code{1}: Normalized matrix where each row is scaled by its biomass marker
\code{2}: Vector of row sums from the scaled matrix
}
\description{
Normalizes pigment ratios differently for Prochlorococcus vs other groups,
using divinyl chlorophyll a for Prochlorococcus and chlorophyll a for others.
}
\examples{
# Create sample F matrix with Prochlorococcus
Fmat <- as.matrix(phytoclass::Fp)
result <- phytoclass:::Prochloro_Normalise_F(Fmat)
}
\keyword{internal}
