% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{phymapnet_reliability}
\alias{phymapnet_reliability}
\title{Edge reliability via hyperparameter ensemble}
\usage{
phymapnet_reliability(
  otu,
  tree,
  th_fixed = 0.95,
  alpha_range = seq(0.01, 0.12, by = 0.01),
  k_range = 2:10,
  epsilon1_range = seq(0, 1, by = 0.1),
  epsilon2_range = seq(0, 1, by = 0.1),
  kernels = c("gaussian"),
  normalizations = c("log", "gmpr", "clr", "tss"),
  consensus_cut = 0.5,
  prune_tree = TRUE,
  progress = TRUE,
  progress_every = 500
)
}
\arguments{
\item{otu}{samples x taxa matrix.}

\item{tree}{phylo tree.}

\item{th_fixed}{fixed quantile threshold for sparsification across all models (e.g., 0.95).}

\item{alpha_range}{numeric vector.}

\item{k_range}{integer vector.}

\item{epsilon1_range}{numeric vector.}

\item{epsilon2_range}{numeric vector.}

\item{kernels}{character vector: "gaussian" and/or "laplacian".}

\item{normalizations}{character vector: subset of c("log","gmpr","clr","tss").}

\item{consensus_cut}{reliability cutoff for binary consensus (default 0.5).}

\item{prune_tree}{prune tree tips not in OTU.}

\item{progress}{print progress every \code{progress_every} models.}

\item{progress_every}{integer.}
}
\value{
A list with rel_mat, consensus_mat, edge_list, N_models, grid.
}
\description{
Runs an ensemble over (alpha, k, epsilon1, epsilon2, kernel, normalization) and
returns edge reliability as selection frequency under fixed sparsification threshold.
}
