% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fit.R
\name{phymapnet_fit}
\alias{phymapnet_fit}
\title{Fit a single PhyMapNet model}
\usage{
phymapnet_fit(
  otu,
  tree,
  alpha = 0.05,
  k = 5,
  epsilon1 = 0,
  epsilon2 = 0,
  kernel = c("gaussian", "laplacian"),
  th_sparsity = 0.95,
  normalization = c("log", "gmpr", "clr", "tss"),
  prune_tree = TRUE
)
}
\arguments{
\item{otu}{samples x taxa matrix.}

\item{tree}{phylo tree with tips matching taxa.}

\item{alpha}{kernel bandwidth (>0).}

\item{k}{neighborhood scaling (integer >= 1). Uses K_neighbors = k * p internally.}

\item{epsilon1}{diagonal jitter for omega_hat.}

\item{epsilon2}{jitter for IB.}

\item{kernel}{"gaussian" or "laplacian".}

\item{th_sparsity}{quantile level for sparsification (e.g., 0.95).}

\item{normalization}{"log","gmpr","clr","tss".}

\item{prune_tree}{prune tree tips not in OTU.}
}
\value{
A list with precision_map, adjacency, threshold, taxa, dist, kernel_mat.
}
\description{
Fit a single PhyMapNet model
}
