% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advs_peds.R
\docType{data}
\name{advs_peds}
\alias{advs_peds}
\title{Vital Signs Analysis for Pediatrics}
\format{
A data frame with 80 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ ASEQ }{Analysis Sequence Number}
\item{ BRTHDTC }{Date/Time of Birth (Character)}
\item{ BRTHDT }{Date/Time of Birth}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ ETHNIC }{Ethnicity}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ ATPT }{Analysis Timepoint}
\item{ ATPTN }{Analysis Timepoint (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARAMN }{Parameter (N)}
\item{ AVAL }{Analysis Value}
\item{ BASE }{Baseline Value}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ ABLFL }{Baseline Record Flag}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ONTRTFL }{On Treatment Record Flag}
\item{ EPOCH }{Epoch}
\item{ VSEVAL }{Evaluator}
\item{ VSSEQ }{Sequence Number}
\item{ VSTESTCD }{Vital Signs Test Short Name}
\item{ VSTEST }{Vital Signs Test Name}
\item{ VSPOS }{Vital Signs Position of Subject}
\item{ VSORRES }{Result or Finding in Original Units}
\item{ VSORRESU }{Original Units}
\item{ VSSTRESC }{Character Result/Finding in Std Format}
\item{ VSSTRESN }{Numeric Result/Finding in Standard Units}
\item{ VSSTRESU }{Standard Units}
\item{ VSSTAT }{Completion Status}
\item{ VSLOC }{Location of Vital Signs Measurement}
\item{ VSBLFL }{Baseline Flag}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ VISITDY }{Planned Study Day of Visit}
\item{ VSDTC }{Date/Time of Measurements}
\item{ VSDY }{Study Day of Vital Signs}
\item{ VSTPT }{Planned Time Point Name}
\item{ VSTPTNUM }{Planned Time Point Number}
\item{ VSELTM }{Planned Elapsed Time from Time Point Ref}
\item{ VSTPTREF }{Time Point Reference}
\item{ AAGECUR }{Current Analysis Age (Days)}
\item{ AAGECURU }{Current Analysis Age Units}
\item{ HGTTMP }{Temporary Height at Timepoint}
\item{ HGTTMPU }{Temporary Height at Timepoint Units}
}
}
\source{
Generated from admiralpeds package (template ad_advs.R).
}
\usage{
advs_peds
}
\description{
Vital Signs Analysis for Pediatrics
}
\details{
Contains a set of 14 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
BMI      \tab Body Mass Index(kg/m^2)              \cr
BMIPCTL  \tab BMI-for-age percentile               \cr
BMISDS   \tab BMI-for-age z-score                  \cr
HDCIRC   \tab Head Circumference (cm)              \cr
HDCPCTL  \tab Head Circumference-for-age percentile\cr
HDCSDS   \tab Head Circumference-for-age z-score   \cr
HEIGHT   \tab Height (cm)                          \cr
HGTPCTL  \tab Height-for-age percentile            \cr
HGTSDS   \tab Height-for-age z-score               \cr
WEIGHT   \tab Weight (kg)                          \cr
WGTAPCTL \tab Weight-for-age percentile            \cr
WGTASDS  \tab Weight-for-age z-score               \cr
WGTHPCTL \tab Weight-for-length/height Percentile  \cr
WGTHSDS  \tab Weight-for-length/height Z-Score
}
}
\examples{
data("advs_peds")
}
\references{
None
}
\keyword{dataset}
\keyword{pediatrics}
