% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguOutliers.R
\name{pgu.outliers}
\alias{pgu.outliers}
\title{pgu.outliers}
\format{
[R6::R6Class] object.
}
\description{
Detects and replaces possible outliers from data set.
}
\details{
Performes Grubb's test for outliers to detect outliers in the normalized and Z-score transfromed data set.
Replace missing values with substitutes by classical and AI-powerd substitution algorithms.
For this purpose outliers are handled as imputation sites.
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{outliersParameter}}{Returns the instance variable outliersParameter.
(tibble::tibble)}

\item{\code{outliers}}{Returns the instance variable outliers.
(tibble::tibble)}

\item{\code{one_hot_df}}{Returns the positions of missings in one_hot encoding
(tibble::tibble)}

\item{\code{outliersStatistics}}{Returns the instance variable outliersStatistics.
(tibble::tibble)}

\item{\code{outliersAgentAlphabet}}{Returns the instance variable of outliersAgentAlphabet
(character)}

\item{\code{outliersAgent}}{Returns the instance variable outliersAgent.
(character)}

\item{\code{setOutliersAgent}}{Sets the instance variable outliersAgent.
(character)}

\item{\code{featureData}}{Returns the instance variable featureData.
(numeric)}

\item{\code{alpha}}{Returns the instance variable alpha.
(numeric)}

\item{\code{setAlpha}}{Set the instance variable alpha.
(numeric)}

\item{\code{epsilon}}{Returns the instance variable epsilon.
(numeric)}

\item{\code{setEpsilon}}{Set the instance variable epsilon.
(numeric)}

\item{\code{minSamples}}{Returns the instance variable minSamples.
(integer)}

\item{\code{setMinSamples}}{Set the instance variable minSamples.
(integer)}

\item{\code{gamma}}{Returns the instance variable gamma.
(numeric)}

\item{\code{setGamma}}{Set the instance variable gamma.
(numeric)}

\item{\code{nu}}{Returns the instance variable nu.
(numeric)}

\item{\code{setNu}}{Set the instance variable nu.
(numeric)}

\item{\code{k}}{Returns the instance variable k
(integer)}

\item{\code{setK}}{Sets the instance variable k.
(integer)}

\item{\code{cutoff}}{Returns the instance variable cutoff.
(numeric)}

\item{\code{setCutoff}}{Sets the instance variable cutoff.
(numeric)}

\item{\code{seed}}{Returns the instance variable seed.
(integer)}

\item{\code{setSeed}}{Set the instance variable seed.
(integer)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.outliers-new}{\code{pgu.outliers$new()}}
\item \href{#method-pgu.outliers-finalize}{\code{pgu.outliers$finalize()}}
\item \href{#method-pgu.outliers-print}{\code{pgu.outliers$print()}}
\item \href{#method-pgu.outliers-resetOutliers}{\code{pgu.outliers$resetOutliers()}}
\item \href{#method-pgu.outliers-filterFeatures}{\code{pgu.outliers$filterFeatures()}}
\item \href{#method-pgu.outliers-checkFeatureValidity}{\code{pgu.outliers$checkFeatureValidity()}}
\item \href{#method-pgu.outliers-detectOutliersParameter}{\code{pgu.outliers$detectOutliersParameter()}}
\item \href{#method-pgu.outliers-outliersFeatureList}{\code{pgu.outliers$outliersFeatureList()}}
\item \href{#method-pgu.outliers-featureOutlier}{\code{pgu.outliers$featureOutlier()}}
\item \href{#method-pgu.outliers-one_hot}{\code{pgu.outliers$one_hot()}}
\item \href{#method-pgu.outliers-detectOutliers}{\code{pgu.outliers$detectOutliers()}}
\item \href{#method-pgu.outliers-detectByGrubbs}{\code{pgu.outliers$detectByGrubbs()}}
\item \href{#method-pgu.outliers-grubbs_numeric}{\code{pgu.outliers$grubbs_numeric()}}
\item \href{#method-pgu.outliers-detectByDbscan}{\code{pgu.outliers$detectByDbscan()}}
\item \href{#method-pgu.outliers-dbscan_numeric}{\code{pgu.outliers$dbscan_numeric()}}
\item \href{#method-pgu.outliers-detectBySvm}{\code{pgu.outliers$detectBySvm()}}
\item \href{#method-pgu.outliers-svm_numeric}{\code{pgu.outliers$svm_numeric()}}
\item \href{#method-pgu.outliers-detectByKnn}{\code{pgu.outliers$detectByKnn()}}
\item \href{#method-pgu.outliers-knn_numeric}{\code{pgu.outliers$knn_numeric()}}
\item \href{#method-pgu.outliers-setImputationSites}{\code{pgu.outliers$setImputationSites()}}
\item \href{#method-pgu.outliers-calcOutliersStatistics}{\code{pgu.outliers$calcOutliersStatistics()}}
\item \href{#method-pgu.outliers-outlierTable}{\code{pgu.outliers$outlierTable()}}
\item \href{#method-pgu.outliers-plotOutliersDistribution}{\code{pgu.outliers$plotOutliersDistribution()}}
\item \href{#method-pgu.outliers-featureBarPlot}{\code{pgu.outliers$featureBarPlot()}}
\item \href{#method-pgu.outliers-featureBoxPlotWithSubset}{\code{pgu.outliers$featureBoxPlotWithSubset()}}
\item \href{#method-pgu.outliers-featurePlot}{\code{pgu.outliers$featurePlot()}}
\item \href{#method-pgu.outliers-clone}{\code{pgu.outliers$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.outliers` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$new(
  data_df = "tbl_df",
  alpha = 0.05,
  epsilon = 0.1,
  minSamples = 4,
  gamma = 0.05,
  nu = 0.1,
  k = 4,
  cutoff = 0.99,
  seed = 42
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be cleaned.
(tibble::tibble)}

\item{\code{alpha}}{Initial definition of the instance variable alpha.
(numeric)}

\item{\code{epsilon}}{Initial definition of the instance variable epsilon.
(numeric)}

\item{\code{minSamples}}{Initial definition of the instance variable minSamples.
(integer)}

\item{\code{gamma}}{Initial definition of the instance variable gamma.
(numeric)}

\item{\code{nu}}{Initial definition of the instance variable nu.
(numeric)}

\item{\code{k}}{Initial definition of the instance variable k.
(integer)}

\item{\code{cutoff}}{Initial definition of the instance variable cutoff.
(numeric)}

\item{\code{seed}}{Initial definition of the instance variable seed.
(integer)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.outliers` object.
(pguIMP::pgu.outliers)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of `pgu.outliers` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.outliers` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-resetOutliers"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-resetOutliers}{}}}
\subsection{Method \code{resetOutliers()}}{
Resets instance variables and
performes Grubb's test for outliers to detect outliers in the normalized and Z-score transfromed data set.
Progresse is indicated by the progress object passed to the function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$resetOutliers(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-filterFeatures"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-filterFeatures}{}}}
\subsection{Method \code{filterFeatures()}}{
Filters attributes from the given dataframe that are known to the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$filterFeatures(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be filtered.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A filterd dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-checkFeatureValidity"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-checkFeatureValidity}{}}}
\subsection{Method \code{checkFeatureValidity()}}{
Checks if the feature consists of a sufficient number of instances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$checkFeatureValidity(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed
(tibble::tibble)}

\item{\code{feature}}{The attribute to be analyzed.
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectOutliersParameter"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectOutliersParameter}{}}}
\subsection{Method \code{detectOutliersParameter()}}{
determines the outliers parameter by analyzing the
tibble data_df and the instance variable outliers.
Results are stored to instance variable outliersParameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectOutliersParameter(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Dataframe to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-outliersFeatureList"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-outliersFeatureList}{}}}
\subsection{Method \code{outliersFeatureList()}}{
Characterizes each row of the data frame as either `complete`
or indicates which attribute has been identified as an outlier within the row.
If multiple attributes' row entries were identified as outliers, the row is characterized by `multiple`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$outliersFeatureList(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of row characteristics.
(character)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-featureOutlier"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-featureOutlier}{}}}
\subsection{Method \code{featureOutlier()}}{
Returns the detected outliers of a given attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$featureOutlier(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute to be analyzed
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attribute's outliers
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-one_hot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-one_hot}{}}}
\subsection{Method \code{one_hot()}}{
Gathers statistical information about missing values
in one hot format.
The result is stored in the instance variable one_hot_df.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$one_hot(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectOutliers"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectOutliers}{}}}
\subsection{Method \code{detectOutliers()}}{
Chooses a method for identification of anomalies based upon the instance variable `outliersAgent`
Detects anomalies in a data frame by one-dimensional analysis of each feature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectOutliers(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectByGrubbs"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectByGrubbs}{}}}
\subsection{Method \code{detectByGrubbs()}}{
Identifies anomalies in the data frame based on Grubb's test.
Iterates over the whole data frame. Calls the object's public function
`grubbs_numeric` until no more anomalies are identified.
The threshold for anomaly detection is defined in the instance variable `alpha`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectByGrubbs(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-grubbs_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-grubbs_numeric}{}}}
\subsection{Method \code{grubbs_numeric()}}{
Performs Grubb's test for anomalies to detect a single outlier in the provided attributes data.
If an outlier is found, it is added to the instance variable `outliers`.
The threshold for anomaly detection is difined in the instance variable `alpha`.
The function indicates a find by a positive feedback.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$grubbs_numeric(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{The attribute within the data frame to be analyzed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Feedback if an outlier was found.
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectByDbscan"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectByDbscan}{}}}
\subsection{Method \code{detectByDbscan()}}{
Identifies anomalies in the data frame based on DBSCAN.
Iterates over the whole data frame. Calls the object's public function
`dbscan_numeric` until all features are analyzed.
The cluster hyper parameter are defined in the instance variables `epsilon` and `minSamples`.
The results of the `dbscan_numeric` routine are added to the instance variable `outliers`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectByDbscan(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-dbscan_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-dbscan_numeric}{}}}
\subsection{Method \code{dbscan_numeric()}}{
Identifies anomalies in a single feature of a data frame based on DBSCAN.
The cluster hyperparameter are defined in the instance variables `epsilon` and `minSamples`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$dbscan_numeric(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{Feature to be analyzed
(character)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame comprising the information about detected anomalies of the feature.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectBySvm"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectBySvm}{}}}
\subsection{Method \code{detectBySvm()}}{
Identifies anomalies in the data frame based on one class SVM.
Iterates over the whole data frame. Calls the object's public function
`svm_numeric` until all features are analyzed.
The cluster hyper parameter are defined in the instance variables `gamma` and `nu`.
The results of the `svm_numeric` routine are added to the instance variable `outliers`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectBySvm(data_df = "tbl_df", progress = "Process")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-svm_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-svm_numeric}{}}}
\subsection{Method \code{svm_numeric()}}{
Identifies anomalies in a single feature of a data frame based on one class SVM.
The cluster hyperparameter are defined in the instance variables `gamma` and `nu`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$svm_numeric(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{Feature to be analyzed
(character)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame comprising the information about detected anomalies of the feature.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-detectByKnn"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-detectByKnn}{}}}
\subsection{Method \code{detectByKnn()}}{
Identifies anomalies in the data frame based on knnO.
Iterates over the whole data frame. Calls the object's public function
`svm_numeric` until all features are analyzed.
The cluster hyper parameter are defined in the instance variables `alpha` and `minSamples`.
The results of the `knn_numeric` routine are added to the instance variable `outliers`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$detectByKnn(data_df = "tbl_df", progress = "Process")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-knn_numeric"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-knn_numeric}{}}}
\subsection{Method \code{knn_numeric()}}{
Identifies anomalies in a single feature of a data frame based on knnO.
The cluster hyperparameter are defined in the instance variables `alpha` and `minSmaples`.
Display the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$knn_numeric(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{Feature to be analyzed
(character)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored in this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame comprising the information about detected anomalies of the feature.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-setImputationSites"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-setImputationSites}{}}}
\subsection{Method \code{setImputationSites()}}{
Replaces the detected anomalies of a user provided data frame with `NA` for further imputation routines.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$setImputationSites(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{Data frame to be mutated.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with anomalies replaced by `NA`.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-calcOutliersStatistics"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-calcOutliersStatistics}{}}}
\subsection{Method \code{calcOutliersStatistics()}}{
Calculates the statistics on the previously performed outlier detection analysis
and stores the results in the instance variable `outliersStatistcs`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$calcOutliersStatistics(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-outlierTable"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-outlierTable}{}}}
\subsection{Method \code{outlierTable()}}{
Creates a datatable with substituted outliers highlightes by colored background.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$outlierTable(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data frame to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A colored datatable
(DT::datatable)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-plotOutliersDistribution"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-plotOutliersDistribution}{}}}
\subsection{Method \code{plotOutliersDistribution()}}{
Displays the occurrence of outlier candidates per attribute as bar plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$plotOutliersDistribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A bar plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-featureBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-featureBarPlot}{}}}
\subsection{Method \code{featureBarPlot()}}{
Displays the distribution of an attribute's values as histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$featureBarPlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A histogram.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-featureBoxPlotWithSubset"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-featureBoxPlotWithSubset}{}}}
\subsection{Method \code{featureBoxPlotWithSubset()}}{
Displays the distribution of an attribute's vlues as box plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$featureBoxPlotWithSubset(
  data_df = "tbl_df",
  feature = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A box plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-featurePlot"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-featurePlot}{}}}
\subsection{Method \code{featurePlot()}}{
Displays the distribution of an attribute's values as a composition of a box plot and a histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$featurePlot(data_df = "tbl_df", feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{dataframe to be analyzed.
(tibble::tibble)}

\item{\code{feature}}{attribute to be shown.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A composite plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.outliers-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.outliers-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.outliers$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
