% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pam_data.R
\name{read_dual_pam_data}
\alias{read_dual_pam_data}
\title{Read and Process DualPAM Data}
\usage{
read_dual_pam_data(
  csv_path,
  remove_recovery = TRUE,
  etr_factor = 0.84,
  fraction_photosystem_I = 0.5,
  fraction_photosystem_II = 0.5
)
}
\arguments{
\item{csv_path}{File path to the CSV file.}

\item{remove_recovery}{Logical. Removes recovery measurements if \code{TRUE}. Default is \code{TRUE}.}

\item{etr_factor}{Numeric. Factor for ETR calculation. Default is \code{0.84}.}

\item{fraction_photosystem_I}{Numeric. Relative distribution of absorbed PAR to photosystem I. Default is \code{0.5}.}

\item{fraction_photosystem_II}{Numeric. Relative distribution of absorbed PAR to photosystem II. Default is \code{0.5}.}
}
\value{
A \code{data.table} containing:
\itemize{
  \item \code{par}: Photosynthetically active radiation.
  \item \code{yield_1}: Yield for photosystem I.
  \item \code{yield_2}: Yield for photosystem II.
  \item \code{etr_1}: Calculated ETR for photosystem I.
  \item \code{etr_2}: Calculated ETR for photosystem II.
}
}
\description{
Reads raw CSV files generated by DualPAM software, calculates electron transport rate (ETR) values, and returns a universal dataset.
}
\details{
Calculates ETR using:
\deqn{\text{ETR} = \text{PAR} \cdot \text{ETR-Factor} \cdot \text{Fraction of Photosystem (I or II)} \cdot \text{Yield (I or II)}}

A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#read_dual_pam_data}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)
}
\references{
{
  Heinz Walz GmbH. (2024). \emph{DUAL-PAM-100 DUAL-PAM/F MANUAL, 5th Edition, April 2024, Chapter 7 (pp. 162-172).}
  Heinz Walz GmbH, Effeltrich, Germany.
  Available at: \url{https://www.walz.com/files/downloads/dualpamed05.pdf}
}
}
