% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxcalSumSim.R
\name{oxcalSumSim}
\alias{oxcalSumSim}
\title{Sum calibration for simulated dates}
\usage{
oxcalSumSim(
  timeframe_begin,
  timeframe_end,
  n,
  stds,
  date_distribution = c("equidist", "uniform")
)
}
\arguments{
\item{timeframe_begin, timeframe_end}{beginning and end of the time frame for which dates should be simulated}

\item{n}{the number of dates that should be simulated}

\item{stds}{either one standard deviation for all dates or a vector of standard deviations with length n}

\item{date_distribution}{a character string indicating which method should be used to distribute the dates in the given time frame, can be abbreviated}
}
\value{
A list containing the following components:
 \item{dates}{the dates for the simulated sum calibration}
 \item{probabilities}{the probabilities for the simulated sum calibration}
 \item{date_distribution}{the distribution method used for the dates}
}
\description{
Sum calibration for simulated dates
}
\details{
The dates can be distributed using one of the following methods:
'equidist' distributed the n dates within the time frame with equal distance,
'uniform' random samples n dates from the given time interval with uniform distribution
}
