% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_character_scalar}
\alias{v_character_scalar}
\title{Validator for Character Scalar Values}
\usage{
v_character_scalar()
}
\value{
A validator function that takes a value \code{x} and raises an error if:
\itemize{
\item \code{x} is not a single character value
\item \code{x} is an empty string
}
}
\description{
\code{v_character_scalar()} returns a validator function that checks if a value
is a single character value. This is useful as a validator function for
options managers created with \code{\link[=create_options_manager]{create_options_manager()}}.
}
\examples{
# Create a validator for non-empty character scalars
validator <- v_character_scalar()

# Valid input
validator("hello")

# Invalid inputs (would raise errors)
try(validator(c("hello", "world")))  # vector, not scalar
try(validator(123))  # numeric, not character
}
