% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holidays.R
\name{oh_school_holidays}
\alias{oh_school_holidays}
\title{Get school holidays for a given country and time period}
\usage{
oh_school_holidays(
  country,
  language = "EN",
  start_date,
  end_date,
  subdivision = NULL
)
}
\arguments{
\item{country}{Country ISO code (e.g., "DE").}

\item{language}{Language code (default: "EN").}

\item{start_date}{Start date in YYYY-MM-DD format.}

\item{end_date}{End date in YYYY-MM-DD format.}

\item{subdivision}{Optional subdivision ID (if you want holidays for a
specific subdivision such as state/province).}
}
\value{
A data frame of school holidays.
}
\description{
This function retrieves school holidays from the OpenHolidays API
for a specified country within a given date range.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
oh_school_holidays(country = "DE",
                   start_date = "2025-01-01",
                   end_date = "2025-01-31")

oh_school_holidays(country = "DE",
                  start_date = "2025-01-01",
                  end_date = "2025-01-31",
                  subdivision = "DE-BY")
\dontshow{\}) # examplesIf}
}
