% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_nypd_hate_crimes.R
\name{nyc_nypd_hate_crimes}
\alias{nyc_nypd_hate_crimes}
\title{NYC NYPD Hate Crimes}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/bqiq-cu78>
}
\usage{
nyc_nypd_hate_crimes(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing NYC NYPD Hate Crimes data.
}
\description{
Downloads NYPD Hate Crimes data from NYC Open Data.
}
\details{
This dataset contains records of hate crime incidents reported by the NYPD.
Each entry includes the bias motivation, offense category, and borough,
providing insight into hate crime trends across New York City.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_nypd_hate_crimes(limit = 10)
head(small_sample)

\donttest{
nyc_nypd_hate_crimes(limit = 5000)
nyc_nypd_hate_crimes(filters = list(county = "KINGS"))
}
}
