% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tail_index.R
\name{tail_index}
\alias{tail_index}
\title{Tail Index for Nominal Variables}
\usage{
tail_index(df, var, threshold = 0.8)
}
\arguments{
\item{df}{A data.frame or tibble containing the variable.}

\item{var}{Character. Name of the nominal variable in \code{df}.}

\item{threshold}{Numeric. Cumulative proportion of counts defining the "dominant" categories (default 0.8).}
}
\value{
Numeric between 0 and 1 representing the tail proportion.
}
\description{
Computes the proportion of categories contributing to the lower part of the distribution.
Useful to quantify long-tail structure in nominal distributions.
}
\examples{
tail_index(categories3, "animal")
tail_index(categories2, "animal", threshold = 0.9)
}
