% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranked_dotplot.R
\name{ranked_dotplot}
\alias{ranked_dotplot}
\title{Ranked Dot Plot for Nominal Variables}
\usage{
ranked_dotplot(
  df,
  var,
  connect = FALSE,
  shade = FALSE,
  scale = c("count", "percent")
)
}
\arguments{
\item{df}{A data.frame or tibble containing the variable.}

\item{var}{Character. Name of the nominal variable in \code{df}.}

\item{connect}{Logical; if TRUE, connects points with a line.}

\item{shade}{Logical; if TRUE, shades the area under the line. Default is FALSE.}

\item{scale}{Character; either \code{"count"} (default) or \code{"percent"}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Creates a ranked dot plot for a nominal variable, displaying
category frequencies or percentages from highest to lowest.
Optionally connects points with a line and shades the area under the line.
}
\examples{
ranked_dotplot(categories, "animal")
ranked_dotplot(categories, "animal", connect = TRUE)
ranked_dotplot(categories, "animal", connect = TRUE, shade = TRUE)
ranked_dotplot(mpg, "manufacturer", scale = "percent")

}
