% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/central_concentration.R
\name{central_concentration}
\alias{central_concentration}
\title{Central Concentration Index for Nominal Variables}
\usage{
central_concentration(df, var, top_k = 3, weighted = FALSE)
}
\arguments{
\item{df}{A data.frame or tibble containing the variable.}

\item{var}{Character. Name of the nominal variable in \code{df}.}

\item{top_k}{Numeric. Number of central categories to consider (default: 3).}

\item{weighted}{Logical. If TRUE, applies a weight decreasing with distance from center.}
}
\value{
A numeric value between 0 and 1 representing the central concentration.
}
\description{
Computes a measure of how concentrated counts are around the center
of a nominal variable, based on the centered plotting order.
}
\examples{
central_concentration(categories, "animal")
central_concentration(categories2, "animal", top_k = 5)
central_concentration(categories3, "animal", weighted = TRUE)

}
