% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centered_dotplot.R
\name{centered_dotplot}
\alias{centered_dotplot}
\title{Centered Dot Plot for Nominal Variables}
\usage{
centered_dotplot(
  df,
  var,
  connect = FALSE,
  shade = FALSE,
  scale = c("count", "percent")
)
}
\arguments{
\item{df}{A data.frame or tibble containing the variable.}

\item{var}{Character. Name of the nominal variable in \code{df}.}

\item{connect}{Logical; if TRUE, connects points with a line.}

\item{shade}{Logical; if TRUE, shades the area under the line (requires connect = TRUE).}

\item{scale}{Character; either \code{"count"} (default) or \code{"percent"}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Creates a centered dot plot for a nominal variable, ordering categories
from the most frequent at the center toward less frequent categories
on both sides. Optionally connects points with a line and shades
the area under the line.
}
\examples{
centered_dotplot(categories, "animal")
centered_dotplot(categories, "animal", connect = TRUE)
centered_dotplot(categories, "animal", connect = TRUE, shade = TRUE)
centered_dotplot(mpg, "manufacturer", scale = "percent")

}
