% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti_extensions.R
\name{parse_extension}
\alias{parse_extension}
\title{Parse NIfTI Extension Data}
\usage{
parse_extension(ext, ...)
}
\arguments{
\item{ext}{A \code{\link{NiftiExtension-class}} object.}

\item{...}{Additional arguments passed to type-specific parsers.}
}
\value{
Parsed data in an appropriate format:
  \itemize{
    \item ecode 4 (AFNI): An XML document (if xml2 available) or character string
    \item ecode 6 (comment): Character string
    \item Other codes: Raw vector (unchanged)
  }
}
\description{
Parses the raw data in a NIfTI extension based on its extension code.
Provides specialized parsing for known extension types.
}
\examples{
# Parse a comment extension
ext <- NiftiExtension(ecode = 6L, data = "Test comment")
parse_extension(ext)  # Returns "Test comment"

}
\seealso{
\code{\link{parse_afni_extension}} for AFNI-specific parsing.
}
