% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/file_format.R
\name{header_file}
\alias{header_file}
\alias{header_file,FileFormat,character-method}
\title{Generic function to get the name of the header file, given a file name and a \code{\linkS4class{FileFormat}} instance.}
\usage{
header_file(x, file_name)

\S4method{header_file}{FileFormat,character}(x, file_name)
}
\arguments{
\item{x}{A \linkS4class{FileFormat} object specifying the format requirements}

\item{file_name}{A character string specifying the file name to derive the header
file name from}
}
\value{
The correct header file name as a \code{character} string.

A character string representing the header file name
}
\description{
Derives the header file name from a given file name based on the FileFormat
specifications.
}
\details{
The function performs the following steps:
\enumerate{
  \item If the input file_name already matches the header file format, it returns
    the file_name as is.
  \item If the file_name matches the data file format, it constructs and returns
    the corresponding header file name.
  \item If the file_name doesn't match either format, it throws an error.
}
}
\examples{

fmt <- new("FileFormat", header_extension = "hdr", data_extension = "img")
header_file(fmt, "brain_scan.hdr")  # Returns "brain_scan.hdr"
header_file(fmt, "brain_scan.img")  # Returns "brain_scan.hdr"


}
\seealso{
\code{\link{data_file}}, \code{\link{strip_extension}} for related file name
manipulation
}
