% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\alias{clean.sites}
\alias{clean.collunits}
\alias{clean.datasets}
\title{clean Neotoma objects to remove duplicates and empty objects.}
\usage{
clean(x, verbose = TRUE, ...)

\method{clean}{sites}(x, verbose = TRUE, ...)

\method{clean}{collunits}(x, verbose = TRUE, ...)

\method{clean}{datasets}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{sites, datasets, collunits that may have duplicates.}

\item{verbose}{parameter to prints out progress bar}

\item{...}{Additional parameters associated with the call.}
}
\value{
clean \code{neotoma} objects without duplicates after concatenation
}
\description{
Function that removes duplicate objects such as sites,
datasets, or collection units. When we pull in a large number of objects,
or overlapping searches, we can run into a problem where we have multiple
instances of the same site, but with different datasets. This function
attempts to gather all objects together:
\itemize{
\item Before: \{site: 1, dataset: 1\}, \{site: 1, dataset: 2\}
\item After: \{site: 1, dataset: [1, 2]\}
So the site is gathered, and the datasets are now part of an
array of datasets.
}
}
\examples{
\dontrun{
tryCatch({
  alex <- get_sites(sitename = "Alex\%")
  alex2 <- get_sites(24)
  c <- c(alex, alex2) #uncleaned
}, error = function(e) {
  message("Neotoma server not responding. Try again later.")
})
}
}
\author{
Simon Goring \email{goring@wisc.edu}
}
