% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_lmer}
\alias{lnr_lmer}
\title{Random/Mixed-Effects (\code{lme4::lmer}) Learner}
\usage{
lnr_lmer(data, formula, weights = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
A wrapper for \code{lme4::lmer} for use in \code{nadir::super_learner()}.
}
\examples{
# random intercepts for each level of cyl column:
lnr_lmer(mtcars, mpg ~ (1|cyl) + disp + am + wt)(mtcars)
}
\seealso{
learners
}
