% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_delete}
\alias{mc_prep_delete}
\title{Delete values by index}
\usage{
mc_prep_delete(data, index_table)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{index_table}{data.frame (table); see details}
}
\value{
raw myClim data with deleted values.
}
\description{
This function is used to delete values in uncleaned raw myClim object by index.
}
\details{
Uncleaned logger contains raw indexes in metadata \verb{@raw_index}. This function
delete values by index_table parameter. This table (data.frame) contains 3 columns:
\itemize{
\item locality_id = id of locality
\item logger_name = name of logger
\item raw_index = index of the value to be deleted
}

This function is used for data checking and validating. Especially in cases
when there are duplicated values for identical time step. This allows you
to manually (visually) select values to be deleted and delete them by table.
}
\examples{
index_table <- data.frame(locality_id = c("A1E05", "A1E05"),
                          logger_name = c("Thermo_1", "Thermo_1"),
                          raw_index = c(1, 2))
data <- mc_prep_delete(mc_data_example_raw, index_table)
}
