% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3-package}
\alias{mlr3}
\alias{mlr3-package}
\title{mlr3: Machine Learning in R - Next Generation}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Efficient, object-oriented programming on the building blocks of machine learning. Provides 'R6' objects for tasks, learners, resamplings, and measures. The package is geared towards scalability and larger datasets by supporting parallelization and out-of-memory data-backends like databases. While 'mlr3' focuses on the core computational operations, add-on packages provide additional functionality.
}
\section{Learn mlr3}{

\itemize{
\item Book on mlr3: \url{https://mlr3book.mlr-org.com}
\item Use cases and examples gallery: \url{https://mlr3gallery.mlr-org.com}
\item Cheat Sheets: \url{https://github.com/mlr-org/mlr3cheatsheets}
}
}

\section{mlr3 extensions}{

\itemize{
\item Preprocessing and machine learning pipelines: \CRANpkg{mlr3pipelines}
\item Analysis of benchmark experiments: \CRANpkg{mlr3benchmark}
\item More classification and regression tasks: \CRANpkg{mlr3data}
\item Connector to \href{https://www.openml.org}{OpenML}: \CRANpkg{mlr3oml}
\item Solid selection of good classification and regression learners: \CRANpkg{mlr3learners}
\item Even more learners: \url{https://github.com/mlr-org/mlr3extralearners}
\item Tuning of hyperparameters: \CRANpkg{mlr3tuning}
\item Hyperband tuner: \CRANpkg{mlr3hyperband}
\item Visualizations for many \pkg{mlr3} objects: \CRANpkg{mlr3viz}
\item Survival analysis and probabilistic regression: \CRANpkg{mlr3proba}
\item Cluster analysis: \CRANpkg{mlr3cluster}
\item Feature selection filters: \CRANpkg{mlr3filters}
\item Feature selection wrappers: \CRANpkg{mlr3fselect}
\item Interface to real (out-of-memory) data bases: \CRANpkg{mlr3db}
\item Performance measures as plain functions: \CRANpkg{mlr3measures}
\item Resampling methods for spatiotemporal data: \CRANpkg{mlr3spatiotempcv}
\item Data storage and prediction support for spatial objects: \CRANpkg{mlr3spatial}
}
}

\section{Suggested packages}{

\itemize{
\item Parallelization framework: \CRANpkg{future}
\item Progress bars: \CRANpkg{progressr}
\item Encapsulated evaluation: \CRANpkg{evaluate}, \CRANpkg{callr} (external process)
}
}

\section{Package Options}{

\itemize{
\item \code{"mlr3.exec_random"}: Randomize the order of execution in \code{\link[=resample]{resample()}} and \code{\link[=benchmark]{benchmark()}} during
parallelization with \CRANpkg{future}. Defaults to \code{TRUE}.
Note that this does not affect the order of results.
\item \code{"mlr3.exec_chunk_size"}: Number of iterations to perform in a single \code{\link[future:future]{future::future()}} during
parallelization with \CRANpkg{future}. Defaults to 1.
\item \code{"mlr3.exec_chunk_bins"}: Number of bins to split the iterations into. If set, \code{"mlr3.exec_chunk_size"} is ignored.
\item \code{"mlr3.debug"}: If set to \code{TRUE}, parallelization via \CRANpkg{future} is disabled to simplify
debugging and provide more concise tracebacks.
Note that results computed in debug mode use a different seeding mechanism and are \strong{not reproducible}.
\item \code{"mlr3.warn_version_mismatch"}: Set to \code{FALSE} to silence warnings raised during predict if a learner has been
trained with a different version version of mlr3.
\item \code{"mlr3.prob_as_default"}: Set to \code{TRUE} to set the predict type of classification learners to
\code{"prob"} by default (if they support it).
\item \code{"mlr3.mirai_parallelization"}: Compute profile to use for parallelization with \CRANpkg{mirai}.
Defaults to \code{"mlr3_parallelization"}.
\item \code{"mlr3.mirai_encapsulation"}: Compute profile to use for encapsulation with \CRANpkg{mirai}.
Defaults to \code{"mlr3_encapsulation"}.
}
}

\section{Error Classes}{

\itemize{
\item \code{Mlr3Error}: The base mlr3 error class.
\item \code{Mlr3ErrorConfig}: This error signals that the user has misconfigured something.
By default, this error is not caught when the learner is encapsulated.
\item \code{Mlr3ErrorInput}: This error signals that the input to the function is invalid.
\item \code{Mlr3ErrorLearner}: The base error class for errors related to the learner.
\item \code{Mlr3ErrorLearnerTrain}: This error signals that the learner failed to train the model.
\item \code{Mlr3ErrorLearnerPredict}: This error signals that something went wrong during prediction.
\item \code{Mlr3TimeoutError}: This error signals that the encapsulation during train or predict timed out.
}
}

\section{Warning Classes}{

\itemize{
\item \code{Mlr3Warning}: The base mlr3 warning class.
\item \code{Mlr3WarningConfig}: This warning signals that the user has misconfigured something.
\item \code{Mlr3WarningInput}: This warning signals that the input to the function is invalid.
}
}

\references{
Lang M, Binder M, Richter J, Schratz P, Pfisterer F, Coors S, Au Q, Casalicchio G, Kotthoff L, Bischl B (2019).
\dQuote{mlr3: A modern object-oriented machine learning framework in R.}
\emph{Journal of Open Source Software}.
\doi{10.21105/joss.01903}, \url{https://joss.theoj.org/papers/10.21105/joss.01903}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3/issues}
}

}
\author{
\strong{Maintainer}: Marc Becker \email{marcbecker@posteo.de} (\href{https://orcid.org/0000-0002-8115-0400}{ORCID})

Authors:
\itemize{
  \item Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID})
  \item Bernd Bischl \email{bernd_bischl@gmx.net} (\href{https://orcid.org/0000-0001-6002-6980}{ORCID})
  \item Jakob Richter \email{jakob1richter@gmail.com} (\href{https://orcid.org/0000-0003-4481-5554}{ORCID})
  \item Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})
  \item Martin Binder \email{mlr.developer@mb706.com}
  \item Florian Pfisterer \email{pfistererf@googlemail.com} (\href{https://orcid.org/0000-0001-8867-762X}{ORCID})
  \item Raphael Sonabend \email{raphaelsonabend@gmail.com} (\href{https://orcid.org/0000-0001-9225-4654}{ORCID})
  \item Sebastian Fischer \email{sebf.fischer@gmail.com} (\href{https://orcid.org/0000-0002-9609-3197}{ORCID})
}

Other contributors:
\itemize{
  \item Giuseppe Casalicchio \email{giuseppe.casalicchio@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0001-5324-5966}{ORCID}) [contributor]
  \item Stefan Coors \email{mail@stefancoors.de} (\href{https://orcid.org/0000-0002-7465-2146}{ORCID}) [contributor]
  \item Quay Au \email{quayau@gmail.com} (\href{https://orcid.org/0000-0002-5252-8902}{ORCID}) [contributor]
  \item Lennart Schneider \email{lennart.sch@web.de} (\href{https://orcid.org/0000-0003-4152-5308}{ORCID}) [contributor]
  \item Lona Koers \email{lona.koers@gmail.com} [contributor]
  \item John Zobolas \email{bblodfon@gmail.com} (\href{https://orcid.org/0000-0002-3609-8674}{ORCID}) [contributor]
  \item Maximilian Mücke \email{muecke.maximilian@gmail.com} (\href{https://orcid.org/0009-0000-9432-9795}{ORCID}) [contributor]
}

}
