% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gof_mlergm.R
\name{plot.gof_mlergm}
\alias{plot.gof_mlergm}
\title{Plot goodness-of-fit results}
\usage{
\method{plot}{gof_mlergm}(
  x,
  ...,
  individual_plots = FALSE,
  save_plots = FALSE,
  show_plots = TRUE,
  width = 8,
  height = 4.5,
  cutoff = NULL,
  x_labels = NULL,
  x_angle = 0,
  x_axis_label = NULL,
  y_axis_label = "Count",
  plot_title = "",
  title_size = 18,
  axis_label_size = 14,
  axis_size = 10,
  line_size = 1,
  x_axis_label_size = NULL,
  y_axis_label_size = NULL,
  x_axis_size = NULL,
  y_axis_size = NULL,
  pretty_x = TRUE
)
}
\arguments{
\item{x}{An object of class \code{gof_mlergm}, produced by \code{\link[mlergm]{gof.mlergm}}.}

\item{\dots}{Additional argument to be passed if necessary.}

\item{individual_plots}{(Logical \code{TRUE} or \code{FALSE}) If \code{TRUE}, individual gof plots are produced. Defaults to 
\code{FALSE}.}

\item{save_plots}{(Logical \code{TRUE} or \code{FALSE}) If \code{TRUE}, the individual GOF plots are saved.}

\item{show_plots}{(Logical \code{TRUE} or \code{FALSE}) If \code{TRUE}, the plots are printed to the screen, and if \code{FALSE} no plots are displayed. This may be helpful when the only desire is to save the individual GOF plots.}

\item{width}{If \code{save_plots == TRUE}, controls the plot width dimension saved.}

\item{height}{If \code{save_plots == TRUE}, controls the plot height dimension saved.}

\item{cutoff}{For statistics that are distributions (e.g., degree distributions), specifies a cutoff point. Dimensions past the cutoff are ignored and not plotted.}

\item{x_labels}{Character vector specifying the statistic names or labels.}

\item{x_angle}{Adjusts the angle of the x axis tick labels (typically the statistic names).}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y aixs.}

\item{plot_title}{Title for the plot.}

\item{title_size}{Font size for the plot title.}

\item{axis_label_size}{Font size for the axis labels. Individual axes label sizes can be changed using \code{x_axis_label_size} and \code{y_axis_label_size} which are detailed below.}

\item{axis_size}{Font size for the axis tick labels. Individual axes tick label sizes can be changed using \code{x_axis_size} and \code{y_axis_size} which are detailed below.}

\item{line_size}{(Numeric, non-negative) If \code{line_size} is positive, then a red line will be plotted to indicate the observed network value of the statistic. If \code{line_size} is equal to zero, then the observed data line will not be plotted.}

\item{x_axis_label_size}{The font size of the x axis label. When \code{NULL}, \code{axis_label_size} is used. Defaults to \code{NULL}.}

\item{y_axis_label_size}{The font size of the y axis label. When \code{NULL}, \code{axis_label_size} is used. Defaults to \code{NULL}.}

\item{x_axis_size}{The font size of the x axis tick labels. When \code{NULL}, \code{axis_size} is used. Defaults to \code{NULL}.}

\item{y_axis_size}{The font size of the y acis tick labels. When \code{NULL}, \code{axis_size} is used. Defaults to \code{NULL}.}

\item{pretty_x}{(Logical \code{TRUE} or \code{FALSE}) If set to \code{TRUE}, the \code{link[base]{pretty}} function will be called to format the x-axis breaks. This can be useful for when the x-axis range is large.}
}
\description{
Produces goodness-of-fit plots for a \code{gof_mlergm} object in order to visualize and assess the fit of an estimated model produced by \code{\link[mlergm]{mlergm}}.
}
