% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{set_user_info}
\alias{set_user_info}
\title{Set user info on a recipe}
\usage{
set_user_info(recipe, user)
}
\arguments{
\item{recipe}{A Recipe object.}

\item{user}{A RecipeUser object.}
}
\value{
The modified Recipe object.
}
\description{
Pipe-friendly function to assign a \code{\link{RecipeUser}} to a Recipe.
}
\examples{
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
user <- recipe_user("Juan Perez", email = "juan@example.com")
r <- r |> set_user_info(user)

}
\seealso{
\code{\link{recipe_user}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
