% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recipes.R
\name{save_recipe}
\alias{save_recipe}
\title{Save Recipe}
\usage{
save_recipe(recipe, file)
}
\arguments{
\item{recipe}{A Recipe object.}

\item{file}{A character string specifying the file path.}
}
\value{
NULL.
}
\description{
Saves a Recipe object to a file in JSON format.
}
\details{
This function encodes the Recipe object
and writes it to a JSON file.
}
\examples{
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
f <- tempfile(fileext = ".json")
save_recipe(r, f)
}
\seealso{
Other recipes: 
\code{\link{Recipe-class}},
\code{\link{add_recipe}()},
\code{\link{bake_recipes}()},
\code{\link{explore_recipes}()},
\code{\link{get_recipe}()},
\code{\link{print.Recipe}()},
\code{\link{publish_recipe}()},
\code{\link{read_recipe}()},
\code{\link{recipe}()},
\code{\link{steps_to_recipe}()}
}
\concept{recipes}
\keyword{utils}
