% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{provenance_to_json}
\alias{provenance_to_json}
\title{Export provenance to JSON}
\usage{
provenance_to_json(prov, path = NULL)
}
\arguments{
\item{prov}{A \code{metasurvey_provenance} list.}

\item{path}{File path to write JSON. If \code{NULL}, returns the JSON string.}
}
\value{
JSON string (invisibly if \code{path} is provided).
}
\description{
Serializes a provenance object to JSON format, optionally writing
to a file.
}
\examples{
svy <- Survey$new(
  data = data.table::data.table(id = 1:5, w = rep(1, 5)),
  edition = "2023", type = "test",
  engine = "data.table", weight = add_weight(annual = "w")
)
prov <- provenance(svy)
provenance_to_json(prov)

}
\seealso{
Other provenance: 
\code{\link{print.metasurvey_provenance}()},
\code{\link{print.metasurvey_provenance_diff}()},
\code{\link{provenance}()},
\code{\link{provenance_diff}()}
}
\concept{provenance}
