% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{certify_recipe}
\alias{certify_recipe}
\title{Certify a recipe}
\usage{
certify_recipe(recipe, user, level)
}
\arguments{
\item{recipe}{A Recipe object.}

\item{user}{RecipeUser who is certifying.}

\item{level}{Character. Certification level:
\code{"reviewed"} or \code{"official"}.}
}
\value{
The modified Recipe object.
}
\description{
Pipe-friendly function to certify a Recipe at a given quality level.
}
\examples{
r <- recipe(
  name = "Example", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Example recipe"
)
inst <- recipe_user("IECON", type = "institution")
r <- r |> certify_recipe(inst, "official")

}
\seealso{
\code{\link{recipe_certification}}, \code{\link{recipe_user}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
