% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypvolgmm.R
\name{hypvolunif}
\alias{hypvolunif}
\title{Approximate hypervolume for multivariate data}
\usage{
hypvolunif(data, pc = FALSE, logarithm = TRUE, ...)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame. If a matrix or
data frame, rows correspond to observations and columns correspond
to variables. Categorical variables and missing values are not allowed.}

\item{pc}{A logical value indicating whether the volume of hyperectangle
enclosing the data (\code{FALSE}) or the volume of hyperectangle aligned with
the principal axes enclosing the data should be computed.}

\item{logarithm}{A logical value indicating whether or not the logarithm
of the hypervolume should be returned.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns the (log) hypervolume from a uniform distribution aligned with the
original axes or along the principal components.
}
\description{
Simple approximations for the hypervolume of a multivariate dataset
by assuming a uniform distribution.
}
\examples{
x1 = rnorm(1000)
x2 = 0.8*x1 + rnorm(1000)
x = cbind(x1, x2)
hypvolunif(x)
hypvolunif(x, pc = TRUE)

}
\author{
Luca Scrucca
}
