% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_functions.R
\name{log_posterior_density}
\alias{log_posterior_density}
\title{Generate log posterior predictive density from a geostatistical surface onto point data}
\usage{
log_posterior_density(draws, validation_data, id_raster, na.rm = FALSE)
}
\arguments{
\item{draws}{(\code{matrix}) A predictive draw matrix, where each row corresponds to a
pixel in the \code{id_raster} and each column corresponds to one sampled estimate of the
outcome.}

\item{validation_data}{(\code{data.frame}) Table containing at least the following
fields:\cr
\itemize{
\item x (\code{numeric}) location x position, in the same projection as \code{id_raster}\cr
\item y (\code{numeric}) location y position, in the same projection as \code{id_raster}\cr
\item indicator (\code{integer}) The number of events in the population\cr
\item samplesize (\code{integer}) The total population, denominator for \code{indicator}
}}

\item{id_raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster}) Raster showing the sample study area, created
using \link{build_id_raster}.}

\item{na.rm}{(\code{logical(1)}, default FALSE) Should NA values be omitted from the LPD
calculation?}
}
\value{
(\code{numeric(1)}) Log predictive density of the validation data given the draw
estimates.
}
\description{
Generate log posterior predictive density from a geostatistical surface onto point data
}
\details{
Calculated across draws. Requires an ID raster to match each point observation
to a set of draws. Assumes binomial data.

For examples, see \code{vignette('model-comparison', package = 'mbg')}
}
\concept{validation}
