% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_dh.R
\name{H_dh}
\alias{H_dh}
\title{Diffuse daily insolation on Mars horizontal surface}
\usage{
H_dh(
  Ls,
  phi,
  longitude,
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Diffuse daily insolation [Wh/m²-day]
}
\description{
Calculates the diffuse solar energy (scattered by atmospheric dust) received over a full
Martian day on a horizontal surface. Obtained by integrating diffuse irradiance from sunrise to sunset.
}
