% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_bh.R
\name{G_bh}
\alias{G_bh}
\title{Direct beam irradiance on Mars horizontal surface}
\usage{
G_bh(Ls, phi, Ts, z = Z(Ls = Ls, phi = phi, Ts = Ts), tau)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{Ts}{Solar time [h]}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}
}
\value{
Direct beam irradiance on horizontal surface [W/m²]
}
\description{
Calculates the direct beam solar irradiance incident on a horizontal surface on Mars.
Accounts for the angle of incidence on the horizontal plane. Implements Equation 18
from Appelbaum & Flood (1990).
}
