% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_mome.R
\name{index_of_mome}
\alias{index_of_mome}
\alias{index_of_momome}
\title{Index of Moderated Mediation
and Index of Moderated Moderated
Mediation}
\usage{
index_of_mome(
  x,
  y,
  m = NULL,
  w = NULL,
  fit = NULL,
  boot_ci = FALSE,
  level = 0.95,
  boot_out = NULL,
  R = 100,
  seed = NULL,
  progress = TRUE,
  mc_ci = FALSE,
  mc_out = NULL,
  ci_type = NULL,
  ci_out = NULL,
  boot_type = c("perc", "bc"),
  skip_indicators = TRUE,
  ...
)

index_of_momome(
  x,
  y,
  m = NULL,
  w = NULL,
  z = NULL,
  fit = NULL,
  boot_ci = FALSE,
  level = 0.95,
  boot_out = NULL,
  R = 100,
  seed = NULL,
  progress = TRUE,
  mc_ci = FALSE,
  mc_out = NULL,
  ci_type = NULL,
  ci_out = NULL,
  boot_type = c("perc", "bc"),
  skip_indicators = TRUE,
  ...
)
}
\arguments{
\item{x}{Character. The name of the
predictor at the start of the path.}

\item{y}{Character. The name of the
outcome variable at the end of the
path.}

\item{m}{A vector of the variable
names of the mediator(s). The path
goes from the first mediator
successively to the last mediator. If
\code{NULL}, the default, the path goes
from \code{x} to \code{y}.}

\item{w}{Character. The name of the
moderator.}

\item{fit}{The fit object. Can be a
\code{lavaan::lavaan-class} object, a list
of \code{\link[=lm]{lm()}} outputs, or an object
created by \code{\link[=lm2list]{lm2list()}}.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::lavaan.mi()}} or
its wrapper, such as \code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::sem.mi()}}.}

\item{boot_ci}{Logical. Whether
bootstrap confidence interval will be
formed. Default is \code{FALSE}.}

\item{level}{The level of confidence
for the bootstrap confidence
interval. Default is .95.}

\item{boot_out}{If \code{boot_ci} is
\code{TRUE}, users can supply pregenerated
bootstrap estimates. This can be the
output of \code{\link[=do_boot]{do_boot()}}. For
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, this can
be the output of a previous call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, or
\code{\link[=cond_indirect]{cond_indirect()}} with bootstrap
confidence intervals requested. These
stored estimates will be reused such
that there is no need to do
bootstrapping again. If not supplied,
the function will try to generate
them from \code{fit}.}

\item{R}{Integer. If \code{boot_ci} is
\code{TRUE}, \code{boot_out} is \code{NULL}, and
bootstrap standard errors not
requested if \code{fit} is a
\code{lavaan-class} object, this function
will do bootstrapping on \code{fit}. \code{R}
is the number of bootstrap samples.
Default is 100. For Monte Carlo
simulation, this is the number
of replications.}

\item{seed}{If bootstrapping
or Monte Carlo simulation is
conducted, this is the seed for the
bootstrapping or simulation.
Default is \code{NULL} and
seed is not set.}

\item{progress}{Logical. Display
bootstrapping progress or not.
Default is \code{TRUE}.}

\item{mc_ci}{Logical. Whether
Monte Carlo confidence interval will be
formed. Default is \code{FALSE}.}

\item{mc_out}{If \code{mc_ci} is
\code{TRUE}, users can supply pregenerated
Monte Carlo estimates. This can be the
output of \code{\link[=do_mc]{do_mc()}}. For
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}, this can
be the output of a previous call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, or
\code{\link[=cond_indirect]{cond_indirect()}} with Monte Carlo
confidence intervals requested. These
stored estimates will be reused such
that there is no need to do
Monte Carlo simulation again. If not
supplied,
the function will try to generate
them from \code{fit}.}

\item{ci_type}{The type of
confidence intervals to be formed.
Can be either \code{"boot"} (bootstrapping)
or \code{"mc"} (Monte Carlo). If not
supplied or is \code{NULL}, will check
other arguments
(e.g, \code{boot_ci} and \code{mc_ci}). If
supplied, will override \code{boot_ci}
and \code{mc_ci}.}

\item{ci_out}{If \code{ci_type} is supplied,
this is the corresponding argument.
If \code{ci_type} is \code{"boot"}, this
argument will be used as \code{boot_out}.
If \code{ci_type} is \code{"mc"}, this
argument will be used as \code{mc_out}.}

\item{boot_type}{If bootstrap
confidence interval is to be formed,
the type of bootstrap confidence
interval. The supported types
are \code{"perc"} (percentile bootstrap
confidence interval, the default and
recommended type) and \code{"bc"}
(bias-corrected, or BC, bootstrap
confidence interval).}

\item{skip_indicators}{Whether
observed indicators are skipped from
the search for product terms. Default
is \code{TRUE}.}

\item{...}{Arguments to be passed to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}}

\item{z}{Character. The name of the
second moderator, for computing the
index of moderated moderated
mediation.}
}
\value{
It returns a
\code{cond_indirect_diff}-class object.
This class has a \code{print} method
(\code{\link[=print.cond_indirect_diff]{print.cond_indirect_diff()}}), a
\code{coef} method for extracting the
index (\code{\link[=coef.cond_indirect_diff]{coef.cond_indirect_diff()}}),
and a \code{confint} method for extracting
the confidence interval if
available
(\code{\link[=confint.cond_indirect_diff]{confint.cond_indirect_diff()}}).
}
\description{
It computes the index of
moderated mediation and the index of
moderated moderated mediation
proposed by Hayes (2015, 2018).
}
\details{
The function
\code{\link[=index_of_mome]{index_of_mome()}} computes the \emph{index
of moderated mediation} proposed by
Hayes (2015). It supports any path in
a model with one (and only one)
component path moderated. For
example, \code{x->m1->m2->y} with \code{x->m1}
moderated by \code{w}. It measures the
change in indirect effect when the
moderator increases by one unit.

The function \code{\link[=index_of_momome]{index_of_momome()}}
computes the \emph{index of moderated
moderated mediation} proposed by
Hayes (2018). It supports any path in
a model, with two component paths
moderated, each by one moderator. For
example, \code{x->m1->m2->y} with \code{x->m1}
moderated by \code{w} and \code{m2->y}
moderated by \code{z}. It measures the
change in the index of moderated
mediation of one moderator when the
other moderator increases by one
unit.
}
\section{Functions}{
\itemize{
\item \code{index_of_mome()}: Compute the
index of moderated mediation.

\item \code{index_of_momome()}: Compute the
index of moderated moderated
mediation.

}}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
dat$xw1 <- dat$x * dat$w1
mod <-
"
m1 ~ a * x  + f * w1 + d * xw1
y  ~ b * m1 + cp * x
ind_mome := d * b
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

# R should be at least 2000 or even 5000 in real research.
# parallel is set to TRUE by default.
# Therefore, in research, the argument parallel can be omitted.
out_mome <- index_of_mome(x = "x", y = "y", m = "m1", w = "w1",
                          fit = fit,
                          boot_ci = TRUE,
                          R = 42,
                          seed = 4314,
                          parallel = FALSE,
                          progress = FALSE)
out_mome
coef(out_mome)
# From lavaan
print(est[19, ], nd = 8)
confint(out_mome)



library(lavaan)
dat <- modmed_x1m3w4y1
dat$xw1 <- dat$x * dat$w1
dat$m1w4 <- dat$m1 * dat$w4
mod <-
"
m1 ~ a * x  + f1 * w1 + d1 * xw1
y  ~ b * m1 + f4 * w4 + d4 * m1w4 + cp * x
ind_momome := d1 * d4
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

# See the example of index_of_mome on how to request
# bootstrap confidence interval.
out_momome <- index_of_momome(x = "x", y = "y", m = "m1",
                              w = "w1", z = "w4",
                              fit = fit)
out_momome
coef(out_momome)
print(est[32, ], nd = 8)

}
\references{
Hayes, A. F. (2015). An index and test of linear moderated mediation.
\emph{Multivariate Behavioral Research, 50}(1), 1-22.
\doi{10.1080/00273171.2014.962683}

Hayes, A. F. (2018). Partial, conditional, and moderated moderated
mediation: Quantification, inference, and interpretation.
\emph{Communication Monographs, 85}(1), 4-40.
\doi{10.1080/03637751.2017.1352100}
}
\seealso{
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
