#' Print Methods for r2 and comp_fit calculation Objects
#' @description
#' Printing objects of class "`r2_kvr2`" (generated by [r2()]) or "`comp_kvr2`" (generated by [comp_fit()]), respectively, by simple print methods.
#'
#' @param x AN object of class "`r2_kvr2`" or "`comp_kvr2`".
#' @param digits The number of significant digits to be used for printing.
#'   Default to 4.
#' @param ... Further arguments passed to or from other methods.
#'
#' @details
#' These methods format the calculated statistics into a human-readable
#' summary, displaying each index or metric with its corresponding value.
#'
#' @return
#' The input object is returned invisibly (via `invisible(x)`).
#' This function is called for its side effect of printing the results of [r2()] or [comp_fit()] calculations to the console.
#'
#' @seealso [r2()] [comp_fit()] [r2_adjusted()]
#'
#' @rdname print.kvr2
#'
#' @export
print.r2_kvr2 <- function(x, ..., digits = 4){
  stopifnot(class(x) == "r2_kvr2")

  sapply(x, function(x){
    cat(chartr("r", "R", names(x)), ": ", format(round(x, digits = digits), nsmall = digits), "\n")
  })

  invisible(x)
}

#' @rdname print.kvr2
#' @export
print.comp_kvr2 <- function(x, ..., digits = 4){
  stopifnot(class(x) == "comp_kvr2")

  sapply(x, function(x){
    cat(names(x), ": ", format(round(x,  digits = digits), nsmall = digits), "\n")
  })

  invisible(x)
}
