% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmassessinformative.R
\name{kmassessinformative}
\alias{kmassessinformative}
\title{Determine next question for probabilistic knowledge assessment}
\usage{
kmassessinformative(probs, ks, update, beta, eta, zeta0, zeta1)
}
\arguments{
\item{probs}{Probability distribution over the knowledge structure (vector)}

\item{ks}{Binary matrix of the knowledge structure}

\item{update}{Update rule ("Bayesian" or "multiplicative")}

\item{beta}{Careless error probabilities (vector)}

\item{eta}{Lucky guess probabilities (vector)}

\item{zeta0}{Vector of update parameters for wrong responses}

\item{zeta1}{Vector of update parameters for correct responses}
}
\value{
Number of the selected question
}
\description{
\code{kmassessinfmrative} determines the next question in a probabiliststic
assessment according to the informative rule.
}
\examples{
kmassessinformative(c(0.02, 0.1, 0.07, 0.01, 0.4, 0.17, 0.07, 0.08, 0.08),
                  xpl$space,
                  "Bayesian",
                  rep(0.3,4),
                  rep(0.2,4),
                  NULL,
                  NULL
                 )

}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassess}()},
\code{\link{kmassessbayesian}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessmentsimulation}()},
\code{\link{kmassessmultiplicative}()}
}
\concept{Knowledge assessment}
